---
name: Pricing
description: Design pricing strategies for products, services, and subscriptions that maximize conversion and value.
metadata: {"clawdbot":{"emoji":"💰","os":["linux","darwin","win32"]}}
---

## Pricing Psychology

- Charm pricing: $9.99 vs $10—left digit effect, perceived as "nine dollars"
- Round numbers for premium: $100 vs $99.99—signals quality, less "deal hunting"
- Remove currency symbols when possible—reduces pain of paying
- Smaller font for decimals—de-emphasizes the cents
- Price per unit can feel smaller—$1/day vs $365/year

## Anchoring

- Show higher price first—makes subsequent prices feel reasonable
- Original price crossed out—anchors value, discount feels real
- Premium tier visible—makes middle tier look affordable
- Competitor comparison when favorable—external anchor

## Tiered Pricing

- Three tiers optimal—too many causes paralysis
- Middle tier is the target—most users choose middle
- Clear differentiation between tiers—obvious value progression
- Feature gaps meaningful—not just "more of same"
- Name tiers descriptively—"Starter, Pro, Enterprise" communicates audience

## Decoy Effect

- Add option that makes target look better—asymmetric dominance
- Decoy slightly worse than target at similar price—pushes toward target
- Works for both pricing and feature comparison
- Decoy doesn't need to sell—just needs to exist

## Freemium Strategy

- Free tier demonstrates value—converts skeptics
- Limit that creates natural upgrade moment—storage full, team size
- Free tier still valuable—not crippled, builds habit
- Clear path from free to paid—upgrade friction minimal
- Track conversion funnel—where do free users drop off

## Trial Design

- Time-limited vs feature-limited—depends on product
- Long enough to experience value—14 days minimum for complex products
- Credit card upfront increases commitment—but reduces trial starts
- Countdown creates urgency—but don't use dark patterns
- Trial extension for engaged users—better than losing them

## Subscription vs One-Time

- Subscription for ongoing value—updates, content, service
- One-time for discrete outcomes—tool purchases, courses
- Hybrid: one-time with optional subscription—maintenance, support
- Annual discount encourages commitment—typically 15-20% off monthly
- Monthly lowers barrier—easier first purchase

## Discounts

- Discount reason increases conversion—launch, holiday, loyalty
- Limited time more effective—scarcity drives action
- First purchase discount—acquisition cost calculation
- Volume discounts—incentivize larger purchases
- Avoid constant discounts—trains customers to wait

## Bundles

- Bundle value higher than sum—or why bundle?
- Hide individual prices when bundled—prevents unbundling math
- Complementary products bundle well—frequently bought together
- "Build your bundle" for customization—perceived control

## Regional Pricing

- Price by purchasing power—same product, different markets
- Local currency—reduces friction, conversion confusion
- Round to local conventions—€9,99 not €9.87
- Consider regional competitors—local alternatives may be cheaper
- VPN/region abuse prevention—if margins matter

## Price Testing

- A/B test carefully—different prices to different users is sensitive
- Test at launch—easier than changing later
- Willingness-to-pay surveys before launch—Van Westendorp method
- Cohort-based experiments—new users only
- Track long-term value, not just conversion—higher price may attract better customers

## Presentation

- Feature comparison table for tiers—easy scanning
- Highlight recommended tier—visual emphasis, "Most Popular" badge
- Show annual savings—monthly × 12 vs annual price
- Calculator for value demonstration—ROI, time saved
- Money-back guarantee—reduces risk perception

## Common Mistakes

- Pricing too low—undervalues product, hard to raise later
- Too many tiers—creates confusion, not options
- Hidden fees revealed late—breaks trust
- Complicated pricing—if explanation needed, simplify
- Ignoring competitor context—price exists in a market
