# Price Manipulation Detection

## Inflated "Original" Prices

- **"Was $199, now $129"** — Check if EVER sold at $199. Often fictional.
- **MSRP theater** — Manufacturers set high MSRP so discounts look impressive.
- **Pre-sale price bumps** — Price raised week before sale, then "discounted" to normal.

## Dynamic Pricing Tactics

- **Demand-based surges** — Prices spike when demand detected (events, weather, news)
- **Cart abandonment tricks** — Leave item in cart, price changes to "encourage" action
- **Personalized pricing** — Some retailers show different prices based on profile (illegal in some places)
- **Time-of-day pricing** — Some services charge more during peak hours

## Fake Urgency Signals

- **"Only 3 left!"** — May be true or manufactured scarcity
- **Countdown timers** — "Sale ends in 2:34:12" often resets
- **"Others are looking"** — Vague, unverifiable pressure tactic
- **Limited time offers** — Check if offer actually expires or quietly continues

## Shrinkflation (Hidden Price Increases)

- **Package size reduction** — Same price, less product. Calculate price-per-unit over time.
- **Formula changes** — "Improved recipe" often means cheaper ingredients
- **Count reductions** — 12-pack becomes 10-pack, price unchanged
- **Concentration changes** — "Now more concentrated" = smaller bottle

## Subscription Traps

- **Introductory pricing** — First 3 months cheap, then 3x price. Calculate annual cost.
- **Hard-to-cancel** — Aggressive retention when trying to cancel
- **Price creep** — Small monthly increases hoping you won't notice
- **Feature gating** — Basic features moved to higher tiers over time

## Marketplace Manipulation

- **Fake reviews** — High rating + generic reviews + new accounts = suspicious
- **Review incentives** — "Leave review for discount" biases ratings
- **Seller rating inflation** — Easy returns/refunds inflate ratings
- **Third-party seller risks** — Same listing, different sellers, different fulfillment quality

## How to Verify

1. **Price history tools** — CamelCamelCamel (Amazon), Keepa, PriceSpy
2. **Wayback Machine** — Check historical product pages
3. **Multiple retailers** — Compare same item across platforms
4. **Review analysis** — Look for patterns suggesting fake reviews
5. **Community knowledge** — Subreddits, forums often expose manipulation
