# Collectibles & Investments

## Fair Market Value Assessment

- **Recent comparable sales** — Not asking prices, SOLD prices. Check multiple platforms.
- **Condition grading** — Same item varies 50%+ based on condition. Verify grade matches comps.
- **Authentication premium** — Authenticated pieces command 10-30% over unverified.
- **Provenance value** — Documented history adds value. "From X collection" matters.

## Price Sources by Category

| Category | Primary Sources | Notes |
|----------|-----------------|-------|
| Watches | Chrono24, WatchCharts | Filter by sold, not listed |
| Art | Artnet, auction results | Private sales underreported |
| Sneakers | StockX, GOAT | Real-time market prices |
| Collectibles | eBay sold, Heritage | Check completed listings |
| Crypto/NFTs | CoinGecko, OpenSea | High volatility, use 7-day avg |

## Trend Analysis

- **Price trajectory** — Is this reference trending up, plateauing, or cooling?
- **2-5 year view** — Single sale doesn't indicate trend. Need pattern.
- **Market context** — Luxury correlates with economy. Watches dip in recession.
- **Hype vs fundamentals** — Sudden spikes often reverse. Slow climbs more stable.

## Overpriced Detection

Red flags:
- **Asking 15%+ above recent comps** — Seller testing inflated price
- **"Rare" without evidence** — Claimed rarity not supported by production numbers
- **Pressure tactics** — "Other buyer interested" = negotiating ploy
- **Missing documentation** — No box/papers but priced as complete

## Entry Point Timing

- **Post-hype dips** — Hot releases often available cheaper 3-6 months later
- **Auction season lulls** — Between major auctions, private sales softer
- **Economic correlation** — Market downturns = buying opportunities for patient buyers
- **New model releases** — Previous generation drops when successor announced

## Resale Value Prediction

Factors that hold/increase value:
- Limited edition (verifiable low production)
- Discontinued with demand
- Cultural significance
- Pristine condition maintained
- Original packaging/papers

Factors that depreciate:
- Mass produced
- Trend-dependent appeal
- Condition degradation risk
- Superseded by better version

## Market Manipulation Signals

- **Thin volume spikes** — Few sales at high prices, then listing at "new floor"
- **Coordinated listings** — Multiple sellers list simultaneously at same inflated price
- **Wash trading** — Same parties buying/selling to inflate perceived value
- **Artificial scarcity** — Withholding inventory to create urgency
