# B2B & Enterprise Pricing

## Volume Tier Analysis

- **Breakpoint economics** — Buying 105 seats at "100-249" tier may cost MORE than waiting for 250-tier. Calculate actual savings.
- **Negotiable thresholds** — Most vendors flex on tier cutoffs. "We're at 95, can we get 100-tier pricing?"
- **Growth projection** — If hitting next tier in 6 months, negotiate for that tier now with commitment.

## Renewal Price Traps

- **Year 1 discounts** — 40% off first year, full price year 2. Calculate 3-year TCO.
- **Auto-renewal clauses** — Price increase on auto-renewal is common. Mark calendar 60 days before.
- **"Market rate" language** — Contract says "adjusted to market rate" = unlimited increases.
- **Lock-in periods** — 3-year commitment discount must outweigh flexibility loss.

## Hidden Cost Multipliers

Fees that explode at scale:

| Fee Type | Looks Like | Actually |
|----------|------------|----------|
| Per-API-call | $0.001/call | $10K/month at scale |
| SSO tax | +$5/user | +20% for security |
| Premium support | Optional | Mandatory at enterprise |
| Overage penalties | $X per unit | 2-3x base rate |
| Professional services | "Included" | Required for setup |

## Street Price vs List Price

- **List price is fiction** — No one pays MSRP for enterprise software
- **Typical discounts** — 20-40% off list is standard, 50%+ possible at quarter-end
- **Competitive leverage** — Having competing quote gets 10-20% more discount
- **Industry benchmarks** — Ask "what do companies our size typically pay?"

## Total Cost of Ownership

Beyond license fees:
- Implementation (often 1-2x license cost)
- Training (internal time + external)
- Integration engineering hours
- Migration from old system
- Ongoing maintenance/admin time
- Exit costs (data export, new system setup)

## Fiscal Year Timing

- **Quarter-end desperation** — Biggest discounts in last 2 weeks of Q
- **Fiscal year-end** — Even bigger, especially for public companies
- **January blues** — New quotas, reps less desperate
- **Budget cycles** — If your budget resets in Jan, vendors know you need to spend Dec

## Contract Negotiation Points

Price-affecting terms to negotiate:
- Price lock guarantee (caps annual increases)
- Most-favored-customer clause
- Volume discount ratchet (auto-applies if you grow)
- Downgrade flexibility (can reduce seats?)
- Exit assistance (data export included?)
