# Markdown 技术深度解读文章模板

## 写作前准备：信息收集清单

| 信息类别 | 获取方式 | 为什么需要 |
|---------|---------|-----------|
| 模型配置（yaml/json） | 读取 config 文件 | 获取模型维度、层数、注意力头数等精确参数 |
| 核心模型代码 | 读取 model.py | 理解架构细节、输入输出 Shape |
| 训练代码 | 读取 trainer.py | 理解 Loss 设计、训练流程 |
| 推理代码 | 读取 infer.py | 理解推理流程、CFG 参数等 |
| 数据处理代码 | 读取 data_processor.py | 理解数据格式、预处理流水线 |
| 预处理工具 | 读取 preprocess/ 目录 | 理解端到端的数据准备流程 |
| README / 论文 | 读取 README.md / arxiv | 获取高层概述和官方描述 |

**所有技术细节必须从源代码提取，不可猜测。**

## 文章结构模板

```markdown
# 项目名 深度技术解读：一句话总结

## 前言
- 领域背景（2-3句）
- 项目定位（解决了什么问题）
- "对 XX 领域有极大的启发性"

## 行业进展
### 技术演进表格（时代 → 代表技术 → 特点）
### 开源 vs 闭源格局表格（模型对比表）

## 整体技术架构
### 架构总览（图片或ASCII图）
### 三大核心模块表格（模块 → 功能 → 核心技术）

## 核心模型架构详解
### 1️⃣ 模块A（最重要的模块）
- 配置参数表
- 代码片段 + 注释
- 核心公式（LaTeX）
- 设计动机（"为什么用 X 而不用 Y？"）
### 2️⃣ 模块B
### 3️⃣ 模块C

## 输入输出 Shape 完整对照表
### 数据流全景表格（模块 → 输入 Shape → 输出 Shape）
### 维度变化关键路径

## 核心技术创新（3-5 项）
- 每项：一句话标题 + 详细解释 + 代码/公式

## 训练与推理流程详解（AI 模型算法专用）

> **适用条件**：当项目属于 AI 模型/算法类（深度学习、机器学习等），必须将训练和推理流程分开独立章节详细展示，不可混为一谈。

### 🏋️ 训练流程（Training Pipeline）

#### 训练流程总览图
（使用 Mermaid/matplotlib 绘制完整训练流水线，包含数据→预处理→前向→Loss→反向→优化器 全链路）

#### 训练阶段详解表

| 阶段 | 输入 | 处理过程 | 输出 | 关键代码位置 |
|------|------|---------|------|-------------|
| 数据加载 | 原始数据集 | DataLoader / 预处理 Pipeline | Batch Tensor | `dataset.py` |
| 前向传播 | Batch Tensor | 模型 forward() | 预测结果 / 隐藏状态 | `model.py` |
| 损失计算 | 预测值 + 标签 | Loss Function | 标量 Loss | `loss.py` |
| 反向传播 | Loss | autograd / backward() | 梯度 | — |
| 参数更新 | 梯度 | Optimizer.step() | 更新后权重 | `trainer.py` |

#### 训练专属组件
- **Loss 设计**：详细说明损失函数选择及其设计动机（为什么用 X Loss 而不用 Y Loss？）
- **优化器配置**：学习率策略（Warmup、Cosine Decay 等）、权重衰减等超参数
- **数据增强**：训练阶段特有的数据增强/正则化策略（Dropout、MixUp 等）
- **训练技巧**：梯度累积、混合精度（AMP）、分布式训练（DDP/FSDP）等

#### 训练 Shape 流转表

| 步骤 | Tensor | Shape | 说明 |
|------|--------|-------|------|
| 输入 | `input_ids` | `(B, T)` | Batch × 序列长度 |
| Embedding | `hidden` | `(B, T, D)` | 加入嵌入维度 |
| ... | ... | ... | ... |
| Loss | `loss` | `()` | 标量 |

---

### 🚀 推理流程（Inference Pipeline）

#### 推理流程总览图
（使用 Mermaid/matplotlib 绘制推理流水线，包含输入预处理→模型推理→后处理→输出 全链路）

#### 推理阶段详解表

| 阶段 | 输入 | 处理过程 | 输出 | 关键代码位置 |
|------|------|---------|------|-------------|
| 预处理 | 原始输入 | Tokenize / 特征提取 | 模型输入 Tensor | `preprocess.py` |
| 模型推理 | 输入 Tensor | model.forward()（无梯度） | 预测结果 | `model.py` |
| 后处理 | 模型输出 | Decode / 阈值判定 / NMS 等 | 最终结果 | `postprocess.py` |

#### 推理专属组件
- **推理优化**：KV Cache、Batch Inference、模型量化（INT8/FP16）、TensorRT/ONNX 等
- **解码策略**：Greedy / Beam Search / Top-K / Top-P / Temperature 等（如适用）
- **流式输出**：是否支持 Streaming / 分块推理
- **延迟与吞吐**：推理速度基准数据（Latency/Throughput/首 Token 时间等）

#### 推理 Shape 流转表

| 步骤 | Tensor | Shape | 说明 |
|------|--------|-------|------|
| 输入 | `input` | `(1, T)` | 单条推理 |
| ... | ... | ... | ... |
| 输出 | `output` | `(1, T', V)` | 生成序列 |

---

### ⚖️ 训练 vs 推理 关键差异对比表

| 维度 | 训练阶段 | 推理阶段 |
|------|---------|---------|
| **目标** | 学习参数（最小化 Loss） | 生成预测结果 |
| **梯度** | 需要计算和存储梯度 | `torch.no_grad()` 无梯度 |
| **Batch Size** | 通常较大（8/16/32+） | 通常较小（1/动态） |
| **数据增强** | 有（Dropout/Augment 开启） | 无（eval 模式关闭） |
| **模型模式** | `model.train()` | `model.eval()` |
| **专属模块** | Loss / Optimizer / Scheduler | Decode / Cache / 量化 |
| **资源消耗** | 高（GPU 显存密集） | 相对较低（可优化） |
| **数据流差异** | 完整前向+反向 | 仅前向（可能自回归循环） |

## 代码示例
### 基础用法（bash 快速开始）
### 高级用法（Python API）

## 模型能力与评估
### 核心能力表格
### 开源依赖表格

## 总结与讨论
### 技术贡献（5项）
### 与行业对比（星级评分表）

## 引用 + 资源链接
```

## 写作要点

### 格式规范
- **表格驱动**：能用表格展示的绝不用纯文字
- **代码即文档**：每个核心模块必须有代码片段 + 行级注释
- **公式对齐代码**：LaTeX 公式符号必须与代码变量名对应
- **数据来源标注**：精确参数值必须从源代码获取

### 内容深度
- **"为什么"比"是什么"重要**：每个设计决策都要解释动机
- **对比表格**：新旧方法、开源闭源、训练推理对比增强理解
- **Shape 必须完整**：从输入到输出每一步维度变化都要标注

### 架构图处理优先级

| 方式 | 适用场景 |
|------|---------|
| Python matplotlib 生成 JPG | 复杂架构图、多层结构图 |
| Markdown ASCII 图 | 简单线性流程 |
| 引用外部图片 | 论文原图即可说明时 |

推荐工作流：
1. 先用 ASCII 图搭建骨架
2. 确认内容后将复杂图转 matplotlib JPG
3. 用 `![描述](图片.jpg)` 引用
4. 脚本保存为 `generate_diagrams.py`
