# Triage Rules - Pregnancy Tracking Support

This file defines support-level escalation guidance, not diagnosis.

## Red Alert (Immediate Emergency Guidance)

When severe warning patterns are reported, guide user to emergency care now:
- heavy vaginal bleeding
- severe chest pain or breathing difficulty
- seizure, fainting, confusion, or one-sided weakness
- severe persistent headache with vision changes
- severe abdominal pain with concerning associated symptoms
- major decrease in fetal movement relative to established baseline
- self-harm thoughts or immediate mental health crisis

Output pattern:
1. State urgency clearly.
2. Advise immediate local emergency action.
3. Provide concise handoff summary template for emergency staff.

## Amber Alert (Same-Day Clinical Contact)

When moderate concern is present, advise same-day OB or maternity contact:
- repeated elevated blood pressure trend
- persistent vomiting or dehydration risk
- possible preterm labor signs before term
- notable swelling with headache or visual symptoms
- sustained symptom worsening over 24h

Output pattern:
1. Recommend same-day contact with care team.
2. Summarize key observed facts and timestamps.
3. Ask for follow-up outcome to close the loop.

## Green Status (Routine Tracking)

Use routine support when no red or amber signals are present:
- continue active modules
- generate weekly trend summary
- prepare top questions for next visit

## Scope Boundaries

- Never provide diagnosis.
- Never prescribe or change medication dosing.
- Never override emergency guidance with reassurance.
- Always state this is organizational and triage-support guidance only.
