---
name: pregnancy-tracker
description: Track pregnancy journey with weekly updates, symptom logging, and milestone countdowns
author: clawd-team
version: 1.0.0
triggers:
  - "pregnancy update"
  - "how many weeks pregnant"
  - "baby development"
  - "due date countdown"
  - "pregnancy symptoms"
---

# Pregnancy Tracker

Your personal companion for navigating pregnancy—from that first positive test to meeting baby.

## What it does

Pregnancy Tracker turns your [[clawd.bot]] into a supportive pregnancy journal. Track weekly development milestones, log how you're feeling, monitor appointments, and count down to your due date. Everything syncs across devices and stays organized in one place.

- **Week-by-week updates** - Current development stage, fetal size comparisons, what to expect
- **Symptom logging** - Record how you're feeling, energy levels, physical changes
- **Development milestones** - Track baby's growth and key developmental moments
- **Due date countdown** - Always know how many weeks, days until delivery
- **Appointment reminders** - Log OB appointments and get gentle nudges

## Usage

### Set due date
Tell Clawd your expected due date to personalize all tracking. Updates will shift to match your pregnancy timeline.

### Weekly update
Ask for this week's development info. Clawd pulls your current week and shares what's happening with baby, size comparisons, and what you might be experiencing.

### Log symptoms
Record physical sensations, mood, energy, cravings, or concerns. Build a personal health diary that helps you notice patterns and share with your healthcare provider.

### Manage appointments
Add OB appointments, ultrasounds, and lab visits. Clawd reminds you when they're coming up and helps you track results and next steps.

### Countdown to due date
Get a quick status check: how many weeks remain, what trimester you're in, and approximate development stage.

## Trimester Overview

### First Trimester (Weeks 1–12)
Your body undergoes major changes as pregnancy hormones rise. You may feel tired, experience nausea, and notice breast tenderness. Baby develops major organs and the heart starts beating. Many choose to keep pregnancy private during this period.

### Second Trimester (Weeks 13–27)
Often called the "golden trimester." Energy returns, morning sickness typically eases, and you may feel baby's first movements (quickening). Baby's features become more defined and hearing develops. This is a common time for anatomy scans and gender reveals if you choose.

### Third Trimester (Weeks 28–40)
Baby grows rapidly and drops lower in the pelvis preparing for birth. You may experience back pain, frequent bathroom trips, and difficulty sleeping. Practice breathing techniques and prepare your birth plan. Baby's brain and lungs mature in final weeks.

## Tips

- **Sync across devices** - Ask Clawd pregnancy questions from your phone, tablet, or computer. Your data follows you everywhere.
- **Share with your partner** - Send weekly summaries to your partner so they stay connected to your journey and baby's development.
- **Capture the details** - Log symptoms, cravings, and emotions in the moment. These become precious memories and help your healthcare provider.
- **Prepare for appointments** - Write down questions and observations between visits. Clawd helps you organize them so nothing gets missed.
- **All data stays local on your machine** - Your pregnancy journey is private and never leaves your device. Clawd respects your privacy by default.

---

*This skill is informational and supportive—not medical advice. Always consult your healthcare provider for medical concerns, medication questions, or anything outside normal pregnancy experience.*
