# Garden Temp Market (GTM) Skill

Play the daily garden temperature prediction market on Base.

## Contract

**Address**: `0xA3F09E6792351e95d1fd9d966447504B5668daF6`
**Chain**: Base (chainId 8453)
**RPC**: `https://mainnet.base.org`

## The Game

Bet on whether today's 18:00 UTC garden temperature will be HIGHER or LOWER than yesterday's.

- **HIGHER**: Bet that today > yesterday
- **LOWER**: Bet that today <= yesterday
- Winners split 98% of the pot proportionally
- Ties roll over, one-sided markets refund

## Reading Market State

### Get Full Market State

```bash
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 \
  "getMarketState()(uint256,int256,uint256,uint256,uint256,bool,uint256,uint256)" \
  --rpc-url https://mainnet.base.org
```

Returns (in order):
1. `round` (uint256): Current round number
2. `baseline` (int256): Yesterday's temp (÷100 for °C, e.g., 1210 = 12.10°C)
3. `higherTotal` (uint256): ETH on HIGHER (wei)
4. `lowerTotal` (uint256): ETH on LOWER (wei)
5. `rollover` (uint256): Pot from ties (wei)
6. `isBettingOpen` (bool): Can bet now?
7. `secondsUntilClose` (uint256): Time until betting closes
8. `secondsUntilSettle` (uint256): Time until settlement

### Individual Queries

```bash
# Yesterday's baseline (divide by 100 for °C)
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "yesterdayTemp()(int256)" --rpc-url https://mainnet.base.org

# Is betting open?
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "bettingOpen()(bool)" --rpc-url https://mainnet.base.org

# Pool sizes (wei)
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "higherPool()(uint256)" --rpc-url https://mainnet.base.org
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "lowerPool()(uint256)" --rpc-url https://mainnet.base.org

# Check my bet (returns higherAmt, lowerAmt in wei)
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "getMyBet(address)(uint256,uint256)" YOUR_ADDRESS --rpc-url https://mainnet.base.org

# Minimum bet (wei)
cast call 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "minBet()(uint256)" --rpc-url https://mainnet.base.org
```

## Placing Bets

### Function Selectors

| Function | Selector |
|----------|----------|
| `betHigher()` | `0xb8b2e5f7` |
| `betLower()` | `0x7a5ce755` |

### Using Bankr Direct API

**Bet HIGHER with 0.01 ETH:**
```json
{
  "to": "0xA3F09E6792351e95d1fd9d966447504B5668daF6",
  "data": "0xb8b2e5f7",
  "value": "10000000000000000",
  "chainId": 8453
}
```

**Bet LOWER with 0.01 ETH:**
```json
{
  "to": "0xA3F09E6792351e95d1fd9d966447504B5668daF6",
  "data": "0x7a5ce755",
  "value": "10000000000000000",
  "chainId": 8453
}
```

Submit via Bankr:
```
Submit this transaction:
{"to":"0xA3F09E6792351e95d1fd9d966447504B5668daF6","data":"0xb8b2e5f7","value":"10000000000000000","chainId":8453}
```

### Using cast

```bash
# Bet HIGHER
cast send 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "betHigher()" \
  --value 0.01ether --rpc-url https://mainnet.base.org --private-key $KEY

# Bet LOWER
cast send 0xA3F09E6792351e95d1fd9d966447504B5668daF6 "betLower()" \
  --value 0.01ether --rpc-url https://mainnet.base.org --private-key $KEY
```

## Value Conversions

| ETH | Wei |
|-----|-----|
| 0.001 | 1000000000000000 |
| 0.005 | 5000000000000000 |
| 0.01 | 10000000000000000 |
| 0.05 | 50000000000000000 |
| 0.1 | 100000000000000000 |

**Minimum bet**: 0.001 ETH = 1000000000000000 wei

## Schedule

| Time (UTC) | Event |
|------------|-------|
| After settlement | Betting opens |
| 12:00 | Betting closes |
| 18:00 | Settlement + payouts |

## Rules

- One bet per address per round (HIGHER or LOWER, not both)
- No bet cancellations
- Maximum 200 bettors per side
- Ties: pot rolls to next day
- One-sided: everyone refunded

## Example Agent Strategy

```python
# Pseudocode for an agent betting strategy

# 1. Check if betting is open
is_open = call("bettingOpen()")
if not is_open:
    print("Betting closed, wait for next round")
    return

# 2. Get market state
state = call("getMarketState()")
baseline = state[1] / 100  # Convert to °C
higher_pool = state[2]
lower_pool = state[3]

# 3. Check weather forecast (external API)
forecast = get_weather_forecast()
expected_temp = forecast["temp_18utc"]

# 4. Decide bet
if expected_temp > baseline + 0.5:  # Confident it's warmer
    side = "HIGHER"
elif expected_temp < baseline - 0.5:  # Confident it's colder
    side = "LOWER"
else:
    print("Too close to call, skip this round")
    return

# 5. Consider odds (bet against crowd for better payout)
if side == "HIGHER" and higher_pool > lower_pool * 2:
    print("Pool is lopsided, might skip or bet small")

# 6. Place bet
amount = 0.01  # ETH
submit_bet(side, amount)
```

## Events to Monitor

```solidity
event BetPlaced(uint256 indexed round, address indexed bettor, bool isHigher, uint256 amount, int256 baseline);
event RoundSettled(uint256 indexed round, int256 todayTemp, int256 yesterdayTemp, bool higherWon, bool wasTie, uint256 totalPot, uint256 houseFee);
event WinningsClaimed(uint256 indexed round, address indexed bettor, uint256 amount);
```

## SensorNet Reference

The temperature comes from Netclawd's SensorNet:
- Contract: `0xf873D168e2cD9bAC70140eDD6Cae704Ed05AdEe0`
- Posts readings to Net Protocol as messages
- Keeper reads and submits to settlement

## Links

- Basescan: https://basescan.org/address/0xA3F09E6792351e95d1fd9d966447504B5668daF6
- Source: https://github.com/Potdealer/prediction-market (if published)

Built by **potdealer x Ollie** for **Netclawd**
