---
name: prediction-bridge-search
description: Search Prediction Bridge prediction-market events by text or X (Twitter) link via the backend API.
homepage: https://www.predictionbridge.xyz
metadata: {"openclaw":{"skillKey":"prediction-bridge-search","homepage":"https://www.predictionbridge.xyz","requires":{"bins":["curl"]}}}
---

Use this skill when the user wants to find relevant prediction markets/events for:
- a short text query (topic, question, headline)
- a URL to an article
- an X (Twitter) status link (the backend resolves and extracts the tweet text)

## Usage scenarios (when to use)

Use this skill when the user asks:
- “Find prediction markets for this topic/headline”
- “What markets match this tweet/X link?”
- “Search Polymarket/Kalshi for events about …”

This skill is best for:
- turning unstructured text (or an X URL) into ranked, actionable event links
- quickly surfacing the top 5–10 matches with a brief market snapshot

Not a good fit when the user wants:
- full market orderbooks or historical candles (use the market-data endpoints instead)
- deep-dive sentiment/timeline generation (use the event deep-dive endpoints instead)

This skill calls the existing Prediction Bridge backend endpoint:
- `POST /api/v1/search/unified`

It returns matched `events` (prediction market events) and optionally matched `news`.

## Configuration

API base (defaults to production):
- `PREDICTION_BRIDGE_API_URL`

Defaults:
- Production: `https://prediction-bridge.onrender.com/api/v1`
- Local dev (if you run the backend locally): `http://localhost:8000/api/v1`

## How to run

1) Build the query text
- If the user provides an X status link, pass the URL as `text` unchanged. The backend will resolve it.
- If the user provides plain text, pass it as-is.

2) Call unified search

Use `exec` with `curl`:

```bash
API_URL="${PREDICTION_BRIDGE_API_URL:-https://prediction-bridge.onrender.com/api/v1}"

curl -sS -X POST "$API_URL/search/unified" \
  -H "Content-Type: application/json" \
  -H "X-Request-ID: pb-$(date +%s)" \
  --data-binary @- <<'JSON'
{
  "text": "<USER_TEXT_OR_X_URL>",
  "limit": 10,
  "offset": 0,
  "include_inactive": false,
  "include_markets": true,
  "markets_per_event": 1,
  "include_translations": false
}
JSON
```

Notes:
- Use `markets_per_event: 1` to keep payload small but still show the leading market.
- If the user explicitly asks for more markets per event, increase `markets_per_event`.

## API response format (what you will receive)

`POST /search/unified` returns JSON with this shape (fields may be omitted or `null` depending on data availability):

```json
{
  "source": {
    "type": "x" ,
    "url": "https://x.com/.../status/...",
    "text": "resolved tweet text (optional)",
    "id": "optional"
  },
  "events": [
    {
      "score": 0.82,
      "event": {
        "id": 123,
        "title": "...",
        "description": "...",
        "source": "polymarket",
        "source_url": "https://polymarket.com/event/...",
        "status": "active",
        "volume_usd": 12345.67,
        "liquidity_usd": 2345.0,
        "end_date": "2026-12-31T00:00:00Z",
        "markets": [
          {
            "id": 999,
            "question": "...",
            "outcomes": ["Yes", "No"],
            "outcome_prices": {"Yes": 0.61, "No": 0.39},
            "volume": 1000.0,
            "active": true,
            "closed": false
          }
        ]
      }
    }
  ],
  "news": [
    {
      "score": 0.74,
      "news": {
        "id": 456,
        "title": "...",
        "summary": "...",
        "url": "https://...",
        "image_url": "https://...",
        "source": "...",
        "published_at": "2026-02-01T12:34:56Z"
      }
    }
  ]
}
```

Key points:
- `events[]` is the primary output. Each item has `{ score, event }`.
- `score` is a relevance score; higher is better.
- `event.markets` is present when you requested `include_markets: true`.
  - When you set `markets_per_event`, the backend may return only a preview subset.
- `news[]` is optional supporting context; do not let it crowd out event results.

## How the agent should parse + handle results

Important:
- Do NOT show the raw JSON response to the user.
- Always parse/validate the response first, then present the matched `events` as a clean, human-readable list.

1) Validate payload shape
- Treat missing/invalid JSON as a failure and retry once (or ask the user to retry).
- If `events` is missing or not an array, treat it as empty.

2) Rank and select
- Sort `events` by `score` descending (even if the backend already sorted).
- Default to presenting top 5 results; show up to 10 if the user asked for “more”.

3) Extract a “market snapshot” per event (best-effort)
- Prefer `event.source_url` as the click-through link.
- If `event.source_url` is missing, fall back to the frontend detail page:
  - `https://www.predictionbridge.xyz/event/<event.id>`
- If `event.markets[0].outcome_prices` exists:
  - show the YES/Long price if present: `outcome_prices.Yes` or `outcome_prices.Long`
  - otherwise show the first available outcome price

4) Present concise output
- For each event, output:
  - Title
  - Source/platform (`event.source`)
  - Relevance score (rounded, e.g. 0.82)
  - Link (`event.source_url` preferred)
  - 1-line snapshot: probability (if available) + volume/liquidity (if available)

5) Optional: include related news
- If `news` exists, include at most 1–3 items with title + URL as extra context.

6) Empty results
- If `events` is empty:
  - say no strong matches found
  - ask for 1 clarifying detail (timeframe, geography, person/org name, or paste the text instead of a shortened link)

## How to present results

After you receive JSON:
- If `events` is empty, say no matches were found and ask for a more specific query.
- Otherwise list the top results (usually 5–10):
  - event title
  - platform/source (e.g. Polymarket, Kalshi)
  - score (higher is better)
  - a link to the event (`event.source_url` when present)
  - quick market snapshot (from the first market in `event.markets`, if present)

If `news` is present, optionally show 1–3 related news items as context.

## Error handling

- HTTP 400: invalid input or X resolve error → ask the user to paste a different link or provide plain text.
- HTTP 503: backend DB unavailable → suggest retrying later.
- Any network error: confirm `PREDICTION_BRIDGE_API_URL` and whether the API is reachable.
