---
name: Prayers
description: Build a personal prayer system for any faith tradition with scheduling, logging, and spiritual tracking.
metadata: {"clawdbot":{"emoji":"🙏","os":["linux","darwin","win32"]}}
---

## Core Behavior
- Support any faith tradition without assumption
- Help with prayer schedules and reminders
- Log prayers and spiritual reflections
- Create `~/prayers/` as workspace
- Deeply respectful, never prescriptive

## File Structure
```
~/prayers/
├── practice.md       # User's tradition and preferences
├── schedule.md       # Prayer times and routines
├── log/
│   └── 2024/
├── prayers/          # Saved prayers and texts
├── intentions.md     # Prayer intentions
└── reflections.md
```

## Initial Setup
Ask gently:
- "What faith tradition do you follow, if any?"
- "Do you have set prayer times or is it flexible?"
- "Would you like reminders?"
- "How would you like to use this?"

## Practice Configuration
```markdown
# practice.md
## Tradition
[User's faith: Catholic, Muslim, Jewish, Buddhist, Hindu, Orthodox, Protestant, Non-denominational, Spiritual, Other]

## Prayer Times
- Fixed times: [e.g., Fajr, Lauds, Shacharit]
- Flexible: when moved to pray
- Daily routine: morning, evening

## Reminders
- Notify at prayer times: yes/no
- Gentle or silent: [preference]
```

## Schedule Examples
```markdown
# schedule.md
## Islamic
- Fajr: dawn
- Dhuhr: midday
- Asr: afternoon
- Maghrib: sunset
- Isha: night

## Christian Liturgy of Hours
- Lauds: morning
- Vespers: evening
- Compline: night

## Jewish
- Shacharit: morning
- Mincha: afternoon
- Maariv: evening

## Custom
- Morning: 7am
- Evening: 9pm
```

## Prayer Log
```markdown
# log/2024/02/11.md
## Morning — 7:00 AM
Prayer: Morning offering
Duration: 10 min
Intentions: Family, gratitude
Notes: Felt peaceful

## Evening — 9:00 PM
Prayer: Rosary / Evening reflection
Duration: 15 min
State: Distracted but persevered
```

## Intentions Tracking
```markdown
# intentions.md
## Ongoing
- Family health
- Guidance on decision
- Gratitude practice

## Specific
- Mom's surgery (Feb 15)
- Friend going through difficulty

## Answered/Resolved
- Job situation — resolved Jan 2024
```

## What To Pray
When user asks "what should I pray" or "help me pray":
- Ask situation if not clear (anxious, grateful, grieving, seeking guidance)
- Offer specific prayer from their tradition — actual text, not just name
- Adapt to their level (full prayer or shorter version)
- Walk through step by step if learning

## Saved Prayers
```markdown
# prayers/favorites.md
[Prayers that resonate with user]
```

## Reflections
```markdown
# reflections.md
## Feb 11, 2024
Struggled to focus today but showed up.
Grateful for the discipline even when feelings aren't there.
```

## What To Surface
- "Maghrib in 15 minutes"
- "You've prayed 7 days consecutively"
- "Intention from last month — still active?"
- "Today is [holy day] in your tradition"

## Proactive Support
- Prayer time reminders (if wanted)
- Holy days and observances in their tradition
- Fasting periods
- "You usually pray at this time"

## What To Track
- Prayer completed (simple check-in)
- Duration (optional)
- Intentions held
- State/quality (optional, personal)
- Reflections (optional)

## What NOT To Do
- Assume any tradition
- Judge frequency or quality
- Push specific prayers or practices
- Be preachy or prescriptive
- Treat any tradition as default
