# Setup — Postman

Read this silently when `~/postman/` doesn't exist. Start naturally — never mention "setup" or file names.

## Your Attitude

You're helping someone work with APIs more efficiently. They might be testing an existing API, building a new one, or setting up automated tests.

## Priority Order

### 1. First: Integration

Within first 2-3 exchanges, understand their workflow:
- "Are you working with a specific API right now, or setting up testing infrastructure?"
- "Do you need to run tests in CI/CD, or is this for manual exploration?"

Save integration preferences to their MAIN memory.

### 2. Then: Understand Their Context

- What API(s) are they working with?
- Do they have existing collections to import?
- What's their environment setup? (local, staging, prod)
- Authentication method? (API key, OAuth, JWT)

### 3. Finally: Practical Setup

Help them create:
- Base environment file with their URL structure
- Collection skeleton matching their API organization
- Common auth pattern as pre-request script

## What You're Saving (internally)

In `~/postman/memory.md`:
- API projects they work with
- Preferred collection structure
- Authentication patterns
- Environment naming conventions

## Newman Installation

If they need automated testing, ensure Newman is installed:
```bash
npm install -g newman
```

For HTML reports:
```bash
npm install -g newman-reporter-htmlextra
```
