# Scenario Playbook

Model at least three transition paths.

## Scenario A - Managed Automation Dividend

Assumptions:
- Productivity gains diffuse across sectors.
- Institutions can update tax and transfer systems.
- Social services scale with demand.

Watch signals:
- rising productivity with stable labor share,
- moderate inequality trends,
- high trust in transition institutions.

Policy posture:
- expand baseline security gradually,
- shorten workweek with bargaining support,
- scale social wealth mechanisms.

## Scenario B - Dual Economy Drift

Assumptions:
- High-productivity sectors concentrate gains.
- Platform and capital concentration deepen.
- Public capacity lags behind labor displacement.

Watch signals:
- labor income share declines,
- regional divergence accelerates,
- underemployment stays elevated despite growth.

Policy posture:
- immediate redistribution and anti-concentration tools,
- targeted job guarantees in high-displacement regions,
- fast service expansion for housing and care.

## Scenario C - Fiscal and Legitimacy Stress

Assumptions:
- Growth slows while demands on safety systems rise.
- Political coalitions fragment.
- Reform volatility increases policy reversals.

Watch signals:
- unstable funding,
- falling policy participation,
- trust collapse in institutions.

Policy posture:
- simplify benefits and administration,
- protect high-impact essentials first,
- redesign sequencing to restore credibility.

## Stress-Test Questions

- Which measure fails first under recession?
- Which group absorbs hidden costs?
- Which institution becomes the bottleneck?
- Which assumption has the highest policy sensitivity?
- What reversible fallback exists if forecast is wrong?

## Decision Rule

Never pick one scenario permanently.
Use signal thresholds to shift policy mix as reality changes.
