# Research Notes - Post-Labor Economics (2023-2026)

Use this evidence map to ground recommendations.

## Labor Market and AI Exposure

- IMF (2024): around 40 percent of global jobs exposed to AI, with higher exposure in advanced economies and mixed effects on complement vs substitution.
- IMF (2024): productivity gains from AI can raise growth, but distribution risks increase without policy adaptation.
- ILO (2023): generative AI more likely to transform tasks than fully eliminate jobs in most occupations.
- ILO (2023): exposure is uneven across occupations and regions, requiring targeted transition design.

## Structural Pressures Beyond AI

- OECD (2024): aging can reduce annual GDP-per-capita growth by about 0.4 percentage points across OECD members by 2060 if policy is unchanged.
- OECD (2024): labor shortages already constrain output and public service delivery in many sectors.
- WEF (2025): demographic shifts and digital transformation jointly reshape demand for work, not just technology alone.

## Distribution and Labor Share

- ILO (2025): labor income share has trended downward globally relative to early 2000s benchmarks.
- ILO (2025): wage growth has recovered in some regions but purchasing-power pressure remains uneven.
- Implication: productivity gains do not automatically become broad wage gains.

## Policy Experiment Signals

- OECD (Finland basic income review): improved well-being and stress outcomes; employment effects modest.
- OpenResearch (US cash transfer trial): gains in security and agency; labor supply effects limited and heterogeneous.
- Interpretation: cash floors help stability, but outcomes depend on service ecosystems and local labor conditions.

## Governance and Adoption Quality

- OECD AI in work survey findings (2025 component): negative labor market impacts remain limited so far, but job quality and worker voice vary by implementation.
- OECD finding: consultation and training improve outcomes compared with unilateral deployment.

## Practical Modeling Implications

- Always separate short-run displacement from long-run productivity effects.
- Build policy bundles: income floor plus services plus ownership or bargaining reform.
- Include fiscal and political feasibility as first-order constraints.
- Track distribution metrics, not only GDP or productivity aggregates.
- Stress-test policy under downturn, low-trust, and concentration scenarios.

## Source Pointers

- IMF AI and labor market note (January 2024)
- ILO generative AI and jobs report (2023)
- ILO World Employment and Social Outlook updates (2025)
- OECD Employment Outlook and policy components (2024-2025)
- WEF Future of Jobs Report 2025
