# Policy Portfolio Builder

Build a post-labor package across four blocks.

## Block A - Baseline Security

Choose one primary floor and one complement:
- unconditional cash floor,
- negative income tax,
- guaranteed minimum income,
- universal basic services basket.

Design choices:
- individual vs household eligibility,
- phase-out rate,
- payment frequency,
- interaction with disability and care support.

## Block B - Work Allocation and Meaningful Activity

Define how needed work is organized when private labor demand weakens:
- job guarantee modules,
- public care corps,
- local climate adaptation teams,
- apprenticeship and transition programs.

Specify entry rules, pay policy, and progression paths.

## Block C - Distribution of Productive Wealth

Pick mechanisms that redirect automation gains:
- payroll automation levy,
- data and model usage royalties,
- social wealth fund,
- broad-based employee ownership,
- platform profit-sharing mandates.

Set clear governance for fund control and payout priorities.

## Block D - Time and Bargaining Reform

Reduce precarity while productivity rises:
- shorter full-time standard,
- right to predictable scheduling,
- portable benefits,
- collective bargaining upgrades,
- transition income during retraining.

Treat time reform as distribution policy, not lifestyle policy.

## Portfolio Validation Checklist

- Coherence: do blocks reinforce each other?
- Fiscal path: funded in each phase?
- Administrative load: state capacity exists?
- Political route: coalition and sequencing realistic?
- Equity: effects tested across vulnerable groups?
- Adaptability: triggers defined for policy tuning?

## Minimal Portfolio Output Format

For each portfolio, always include:
- objective,
- target population,
- instruments by block,
- financing,
- risks,
- first 12-month actions,
- stop or revise conditions.
