# Indicators for Post-Labor Transition

Track outcomes with a mixed dashboard.

## Labor Market Core

- Employment-to-population ratio
- Underemployment rate
- Median real wage growth
- Labor income share of GDP
- Transition duration after displacement

## Distribution and Security

- Income floor coverage rate
- Poverty and severe poverty rates
- Consumption volatility in bottom quintiles
- Household financial fragility index
- Access-to-essential-services index

## Productivity and Automation Capture

- Sector productivity growth
- Capital share by sector
- Automation gain capture rate (public plus household)
- Profit concentration ratio
- SME survival under automation pressure

## Work Quality and Time

- Average weekly hours by wage decile
- Involuntary part-time share
- Schedule volatility index
- Care burden distribution by gender
- Burnout or mental strain indicators

## Institutional and Political Health

- Trust in economic institutions
- Policy uptake and retention rates
- Administrative error and exclusion rates
- Collective bargaining coverage
- Regional inequality gap

## Operating Rules

- Use 6 to 12 core indicators, not 40.
- Assign green, amber, red thresholds for each metric.
- Tie each red signal to a specific policy response.
- Review monthly for tactical decisions, quarterly for structural revision.
- Keep metadata for each metric: source, lag, confidence.

## Alert Patterns

- Productivity up + labor share down -> prioritize distribution and ownership tools.
- Income floor up + insecurity unchanged -> service gaps or housing costs are binding.
- Employment stable + stress rising -> work quality and time reform are lagging.
- Good averages + bad regional tails -> add place-based transition policy.
