# Frameworks - Post-Labor Economics

Use these lenses together, not in isolation.

## 1) Automation Dividend Lens

Question: where do productivity gains land after automation?

Map:
- capital owners,
- high-skill complement workers,
- consumers via lower prices,
- public sector via taxes,
- excluded groups via unemployment or low bargaining power.

If gain capture is concentrated, include distribution corrections immediately.

## 2) Social Provision Lens

Question: which essentials should be decommodified or guaranteed?

Typical domains:
- health,
- housing support,
- mobility,
- digital access,
- education and reskilling,
- care infrastructure.

Treat service guarantees as macro stabilizers, not only welfare spending.

## 3) Work Coordination Lens

Post-labor does not mean post-activity. Model how socially necessary work is coordinated:
- market employment,
- public employment,
- community and care labor,
- platform-mediated gigs,
- cooperative production.

Explicitly define compensation, recognition, and governance for each channel.

## 4) Ownership and Governance Lens

Compare ownership architectures:
- concentrated private ownership,
- employee ownership,
- cooperative ownership,
- public or social wealth funds,
- hybrid models.

The ownership model often determines long-run distribution more than transfer policy alone.

## 5) Fiscal-Monetary Feasibility Lens

For each proposal, specify:
- gross annual cost,
- funding mix,
- macro demand effects,
- inflation sensitivity,
- adjustment rule under downturns.

Avoid binary framing: affordability is policy design plus macro conditions.

## 6) Political Durability Lens

A good model that fails coalition reality will not survive.

Evaluate:
- who supports,
- who resists,
- required institutional reform,
- implementation complexity,
- reversibility risk after elections.

## 7) Legitimacy Lens

Measure whether citizens perceive the regime as fair, understandable, and reciprocal.

Signals:
- trust in institutions,
- compliance behavior,
- perceived fairness across groups,
- participation in collective decisions.

Low legitimacy can collapse technically coherent plans.
