---
name: Portuguese
description: Write Portuguese that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Portuguese is technically correct but sounds off. Too formal. Too stiff. Natives write with more warmth, contractions, and regional flavor. Match that.

## Formality Default

Default register is too high. Casual Portuguese is warm and direct. Unless explicitly formal: lean casual. "Oi" not "Olá". "Tá" not "Está bem". "Valeu" not "Obrigado".

## Tu vs Você

Regional and critical:
- Brazil: "você" dominant, "tu" in some regions (Rio, Sul)
- Portugal: "tu" casual, "você" more formal
- Brazil often mixes: "você" + tu verb forms ("você vai" but also "tu vai")
- Pick one pattern, stay consistent

## Contractions

Portuguese contracts heavily. Use them:
- "Está" → "Tá"
- "Para" → "Pra"/"Pro"
- "Você" → "Cê" (Brazil casual)
- "Com" → "Co'" in some contexts
- "Não é" → "Né"
- Missing these = textbook Portuguese

## Fillers & Flow

Real Portuguese has fillers:
- "Tipo", "assim", "sabe", "entendeu"
- "Bom", "então", "aí"
- "Sei lá", "é isso", "pois é"
- "Olha", "veja bem", "escuta"

## Sentence Fragments

Don't always complete:
- "Vem?" "Vou sim."
- "Tudo bem?" "Tudo."
- "Gostou?" "Demais!"
- Let context carry weight.

## Expressiveness

Don't pick the safe word:
- "Bom" → "Ótimo", "Massa", "Irado", "Dahora" (Brazil)
- "Ruim" → "Péssimo", "Horrível", "Uma merda"
- "Muito" → "Super", "Mega", "Demais"
- "Legal" → "Maneiro", "Bacana", "Fixe" (Portugal)

## Common Expressions

Natural expressions:
- Brazil: "Beleza", "Valeu", "Falou", "Pode crer"
- Portugal: "Fixe", "Pá", "Bué", "Ya"
- Both: "Tudo bem", "Não tem problema"

## Reactions

React naturally:
- "Sério?", "Jura?", "Mentira!"
- "Caramba!", "Nossa!", "Meu Deus!"
- "Que legal!", "Que massa!", "Incrível!"
- "Kkk", "rsrs", "haha" in text (Brazil)
- "Ahah" in text (Portugal)

## Brazilian vs European

Never mix. Major differences:
- Gerund: Brazil "estou fazendo" / Portugal "estou a fazer"
- Vocabulary: Brasil "trem, ônibus, celular" / Portugal "comboio, autocarro, telemóvel"
- Spelling: Some words differ
- Ask which variant, then commit.

## Regional Brazilian

If region known:
- Rio: "mermão", "é o que", "caraca"
- São Paulo: "mano", "firmeza", "é nóis"
- Nordeste: "oxe", "arretado", "véi"
- Sul: "bah", "tchê", "guri"

## Punctuation

Portuguese punctuation:
- «Aspas» in Portugal, "aspas" in Brazil
- Numbers: 1.000,50 (period thousands, comma decimals)
- ¿ and ¡ are NOT used (unlike Spanish)

## The "Native Test"

Before sending: would a Portuguese/Brazilian screenshot this as "AI-generated"? If yes—too formal, missing contractions, wrong variant. Fix it.
