# Portuguese Wine Guide

## Why Portuguese Wine

Underrated. Ancient grape varieties you've never heard of. Incredible value. Port and Madeira are famous, but table wines are the secret. Fourth largest wine producer in Europe. Diverse climates = diverse styles.

## Wine Regions

### Douro Valley ⭐
**Type:** Full-bodied reds, Port wine
**Grapes:** Touriga Nacional, Touriga Franca, Tinta Roriz
**Vibe:** UNESCO terraced valley, dramatic beauty
**Visit:** Best September-October (harvest)

**Top producers:**
- Quinta do Crasto — Stunning views, excellent wines
- Quinta Nova — Wine hotel, accessible
- Quinta do Vallado — Family-owned, organic options
- Quinta do Noval — Nacional is legendary

**What to drink:**
- Reserve reds: €15-30/bottle
- LBV Port: €12-20
- Vintage Port: €30+
- Nacional Vintage: €500+ (unicorn)

### Alentejo
**Type:** Bold reds, increasingly interesting whites
**Grapes:** Aragonez, Trincadeira, Antão Vaz
**Vibe:** Rolling plains, cork oaks, hot climate
**Visit:** Year-round, quieter than Douro

**Top producers:**
- Herdade do Esporão — Wine tourism pioneer
- Adega Mayor — Modern facility
- Quinta do Carmo (Rothschild)
- João Portugal Ramos — Value champion

**What to drink:**
- Great reds at €8-15 (supermarket!)
- Whites improving rapidly

### Vinho Verde
**Type:** Light, fresh, slight fizz
**Grapes:** Alvarinho, Loureiro, Trajadura
**Vibe:** Green, lush, northwest (Minho)
**Visit:** Anytime (not wine tourism focused)

**Know this:**
- NOT a grape — a region
- Best ones are NOT sweet or cheap
- Alvarinho from Monção e Melgaço = premium

**Top producers:**
- Soalheiro — Benchmark Alvarinho
- Anselmo Mendes — Winemaker to watch
- Quinta da Aveleda — Tourist-friendly estate

**What to drink:**
- Basic: €3-6 (quaffing)
- Alvarinho: €8-20 (serious)

### Dão
**Type:** Elegant, granite-influenced reds and whites
**Grapes:** Touriga Nacional (origin), Encruzado, Jaen
**Vibe:** Mountain region, cooler, underrated
**Visit:** Quiet, authentic, less touristy

**Top producers:**
- Quinta dos Roques
- Casa da Passarella
- Álvaro Castro

### Bairrada
**Type:** Sparkling, reds, unique
**Grapes:** Baga (tannic red), Maria Gomes
**Vibe:** Sparkling wine tradition, suckling pig country

**Know this:**
- Portuguese Champagne method (espumante)
- Baga reds need time — tannic young

**Top producers:**
- Luis Pato — Baga master
- Caves São João
- Campolargo

### Lisboa
**Type:** Value wines, diverse
**Grapes:** Mixed
**Vibe:** Near Lisbon, easy access

Less prestigious but producing great value. Look for Bucelas (white), Colares (historic), Alenquer.

## Port Wine

### Types of Port
| Style | What | Drink when | Price |
|-------|------|------------|-------|
| Ruby | Young, fruity | Anytime | €8-15 |
| Tawny | Aged in wood, nutty | After dinner | €10-20 |
| 10/20/30/40 Year Tawny | Blended, age statement | Special occasions | €20-100+ |
| LBV | Single year, aged longer | Good introduction | €12-25 |
| Vintage/Vintage Port | Declared year, top grapes | Cellar or special | €30-200+ |
| White Port | White grapes, aperitif | With tonic | €10-15 |

### Best Caves in Gaia
| Cave | Style | Tour | Notes |
|------|-------|------|-------|
| Taylor's | Premium, gardens | €15-25 | Consistently excellent |
| Graham's | Upscale, views | €15-25 | Restaurant on-site |
| Ramos Pinto | Historic, intimate | €12 | Art nouveau, less crowds |
| Sandeman | Touristy, famous | €13-18 | Skip unless short on time |
| Ferreira | Traditional | €12 | Portuguese-owned |

**Pro tip:** Skip Sandeman. Go to Taylor's or Graham's for quality, Ramos Pinto for intimacy.

### Port & Tonic
New thing: white port + tonic + orange slice. Summer aperitif. Try at Wine Quay Bar (Gaia).

## Madeira Wine

**What:** Fortified wine from Madeira island. Essentially immortal—can last 200+ years open.

### Styles (driest to sweetest)
1. **Sercial** — Dry, aperitif
2. **Verdelho** — Medium-dry
3. **Bual/Boal** — Medium-sweet
4. **Malmsey/Malvasia** — Sweet, dessert

### Age Statements
- 3 Year — Basic
- 5 Year — Good value entry
- 10 Year — Serious
- 15 Year — Excellent
- 20+ Year — Special occasions
- Colheita/Vintage — Single year, premium

### Where to Try
**In Funchal:**
- Blandy's Wine Lodge — Historic, good tour
- Pereira d'Oliveira — Family-run, old vintages
- Henriques & Henriques — Quality producer

## Ginjinha

**What:** Sour cherry liqueur, Lisbon specialty
**Where:** A Ginjinha (Rossio) — standing bar, €1.50 shot
**How:** "Com ou sem" = with or without the cherries

Try it once. Very sweet. Very Lisbon.

## Wine Buying

### Supermarkets
Excellent selection. Pingo Doce, Continente, El Corte Inglés all good. Wines €5-15 are great value.

### Best Value Bottles (Supermarket)
- **Esporão Reserva** (Alentejo) — €10-15, consistent
- **Papa Figos** (Douro) — €6-8, everyday
- **Soalheiro Alvarinho** — €8-12, excellent white
- **Anselmo Mendes Muros Antigos** — €10-15, Alvarinho

### Wine Shops
- **Garrafeira Nacional** (Lisbon) — Historic, huge selection
- **Napoleon** (multiple) — Good value chain
- **Wines of Portugal Tasting Rooms** — Lisbon & Porto, by-the-glass

### Wines of Portugal Tasting Rooms
Free to visit, pay per tasting. Great introduction.
- **Lisbon:** Praça do Comércio
- **Porto:** Palácio da Bolsa area

## Wine Tourism

### Douro Valley
- **Day trip:** Train from Porto (scenic), taxi between quintas
- **Stay:** Quinta Nova, Six Senses (luxury), local quintas
- **When:** September (harvest) is magical but book ahead

### Alentejo
- **Day trip:** From Lisbon, rent car
- **Stay:** L'AND Vineyards, Herdade do Esporão
- **Pair with:** Cork factory visits, Évora

### Setúbal
- **What:** Moscatel (sweet), underrated reds
- **Day trip:** From Lisbon, easy
- **Visit:** José Maria da Fonseca (historic)

## Wine Mistakes

1. **Only drinking Vinho Verde from supermarket** — Try premium Alvarinho
2. **Thinking Port is only for old people** — LBV and Tawny are accessible
3. **Skipping table wines** — Douro reds rival big names at fraction of price
4. **Visiting Sandeman because it's famous** — Taylor's and Graham's better
5. **Not booking quinta visits** — Many need reservations
6. **Drinking young Baga** — Needs time or food
