# Phone & Internet in Portugal

## Mobile Networks

### Main Operators
| Operator | Coverage | Notes |
|----------|----------|-------|
| MEO | Best | Largest, best rural coverage |
| NOS | Good | Strong in cities |
| Vodafone | Good | International brand |

**All three:** Good 4G/5G in cities and tourist areas. Rural areas: MEO slightly better.

## Tourist SIM Options

### Where to Buy
- **Airport:** MEO, Vodafone shops at arrivals
- **City:** Phone shops, shopping malls
- **Supermarkets:** Pingo Doce, Continente sell prepaid

### What You Need
- Passport (mandatory for SIM registration)
- Cash or card
- Unlocked phone

### Typical Packages
| Operator | Data | Validity | Price | Notes |
|----------|------|----------|-------|-------|
| MEO | 10GB | 15 days | €15 | Easy to buy |
| Vodafone | 10GB | 14 days | €15 | Airport available |
| NOS | 12GB | 30 days | €20 | Longer validity |

**Top-up:** At any multibanco (ATM), supermarket, or phone shop

### eSIM Options
If phone supports eSIM:
- **Airalo** — Buy before arrival, €5-15 for 1-5GB
- **Holafly** — Unlimited data, €19/5 days
- **Ubigi** — Good coverage

**Tip:** eSIM = no physical SIM needed, activate before landing

## EU Roaming

### If You Have EU SIM
**Free roaming** within EU since 2017. Your home plan works in Portugal.

**Fair use limits:** Check with provider, usually generous for short trips.

**Best approach:** If you have EU phone, just use your normal plan.

### UK Post-Brexit
Most UK plans now charge for EU roaming. Check your provider.
- Some still include limited EU roaming
- Consider local SIM or eSIM if staying 1+ week

### US/Canada
- Roaming very expensive
- Get local SIM or eSIM
- T-Mobile has some international plans

## WiFi

### Availability
**Excellent** in Portugal. WiFi widely available:

- Hotels/hostels: Almost always free
- Cafés/restaurants: Usually free (ask for password)
- Shopping malls: Free
- Airports: Free
- Public spaces: Some cities have free municipal WiFi

### Speed
Generally good. Portugal has decent internet infrastructure.

### Tips
- Ask "Qual é a password do WiFi?" (What's the WiFi password?)
- In cafés: Usually on receipt or ask staff
- Some places limit time/bandwidth for non-customers

## Useful Numbers

### Emergency
- **112** — Universal emergency (police, fire, ambulance)
- **117** — SOS (highway emergency)

### Services
- **808 200 200** — Tourist assistance line
- **+351 808 200 200** — From abroad

### Country Code
- Portugal: **+351**
- Lisbon area: starts with 21
- Porto area: starts with 22
- Mobile: starts with 9

## Staying Connected

### Messaging
- **WhatsApp** — Universal in Portugal
- **Messenger** — Also popular
- **iMessage** — Works if you have data

### Video Calls
- WhatsApp video
- FaceTime (if Apple)
- Google Meet/Zoom

### Apps That Need Data
Make sure you have data for:
- Uber/Bolt
- Google Maps
- Translation apps
- WhatsApp

## Offline Prep

### Download Before Arriving
- Google Maps: Portugal offline maps
- Google Translate: Portuguese language pack
- Spotify: Playlists for offline
- Netflix: Shows for flights/downtime

### Offline Capable
- Maps.me — Full offline maps
- Wikiloc — Hiking trails offline
- Citymapper — Some offline capability (limited Portugal)

## Data Usage Tips

### Save Data
- Download maps/content on WiFi
- Disable auto-updates
- Use WiFi calling if available
- Compress images before sharing

### Approximate Usage
| Activity | Data |
|----------|------|
| Messaging | Minimal |
| Maps navigation | 5-10MB/hour |
| Social media browsing | 50-100MB/hour |
| Video streaming | 1-3GB/hour |
| Music streaming | 50-150MB/hour |

### Realistic Needs
- Light use (maps, messaging): 1-2GB/week
- Moderate (social, some video): 5GB/week
- Heavy (streaming, hotspot): 10GB+/week

## Calling Home

### Cheapest Options
1. **WhatsApp/FaceTime audio** — Free on WiFi/data
2. **Skype** — Cheap international calls
3. **Local SIM** — Reasonable rates to call abroad

### From Hotel
- Often expensive
- Use WiFi calling instead

## Business Travel

### Conference Calls
- Stable WiFi in most hotels/coworking
- Backup: Tether from phone

### Coworking Spaces
- **Lisbon:** Second Home, Heden, Factory
- **Porto:** Porto i/o, CRU
- Good for reliable WiFi + workspace
