# Portuguese Regions Overview

## Mainland Regions

### Lisboa e Vale do Tejo
**Capital:** Lisbon
**Why visit:** Capital city, Sintra palaces, Cascais beaches, Arrábida
**Best for:** First-time visitors, culture, food, nightlife
**Time needed:** 4-7 days

**Highlights:**
- Lisbon (3-4 days minimum)
- Sintra (full day)
- Cascais/Estoril (half day)
- Arrábida (day trip with car)
- Setúbal (seafood)

### Norte (North)
**Capital:** Porto
**Why visit:** Porto, Douro Valley, Peneda-Gerês, Minho
**Best for:** Wine, nature, authentic Portugal
**Time needed:** 4-7 days

**Highlights:**
- Porto (2-3 days)
- Douro Valley (1-2 days)
- Guimarães (day trip)
- Braga (day trip)
- Peneda-Gerês (2-3 days for hiking)

**Character:** More traditional, conservative, rainy winters. Best food (some say).

### Centro (Central)
**Capital:** Coimbra
**Why visit:** Historic villages, Serra da Estrela, Coimbra University
**Best for:** Off-the-beaten-path, mountain hiking, history buffs
**Time needed:** 3-5 days

**Highlights:**
- Coimbra (1-2 days) — University, fado tradition
- Serra da Estrela (2-3 days) — Portugal's highest mountains
- Aldeias Históricas — 12 preserved stone villages
- Óbidos (day trip) — Walled medieval village
- Tomar (day trip) — Knights Templar

**Character:** Underrated. Less touristy. Academic tradition (Coimbra).

### Alentejo
**Capital:** Évora
**Why visit:** Wine, cork, slow pace, starry skies, beaches (coast)
**Best for:** Wine lovers, rural escape, foodies
**Time needed:** 3-5 days

**Highlights:**
- Évora (1-2 days) — UNESCO, Roman temple, bone chapel
- Wine estates (1-2 days) — Herdade do Esporão, others
- Costa Vicentina (2-3 days) — Wild Atlantic coast
- Monsaraz — Hilltop village, stunning

**Character:** Empty, slow, hot summers. Porco preto (black pig). Portugal's best olive oil. Dark sky reserves (no light pollution).

### Algarve
**Capital:** Faro
**Why visit:** Beaches, cliffs, sunshine, golf
**Best for:** Beach holidays, families, retirees
**Time needed:** 5-7 days

**Highlights:**
- Lagos (2-3 days) — Best town, beaches, nightlife
- Tavira (2 days) — Quiet, pretty, islands
- Sagres (1-2 days) — Wild, surfing, edge of Europe
- Benagil Cave — Boat/kayak access

**Character:** Most touristy region. 300+ sunny days. Resort infrastructure. Mix of overdeveloped (Albufeira) and unspoiled (west coast).

## Islands

### Madeira
**Capital:** Funchal
**Why visit:** Levadas (irrigation channel walks), subtropical gardens, Poncha, year-round mild weather
**Best for:** Hikers, nature lovers, older travelers
**Time needed:** 5-7 days

**Highlights:**
- Funchal (1-2 days) — Gardens, market, Old Town
- Levada walks (multiple days) — 25 Fontes, Caldeirão Verde
- Pico do Areeiro to Pico Ruivo (full day) — Mountain hike
- Porto Moniz — Natural lava pools
- Monte Palace Gardens

**No beaches:** Volcanic island = pebbles and rocks. Come for mountains, not sand.

**Character:** Older tourism crowd, but adventure tourism growing. British connections. Cristiano Ronaldo's hometown.

### Azores (9 islands)
**Capital:** Ponta Delgada (São Miguel)
**Why visit:** Volcanic landscapes, whale watching, hot springs, unspoiled nature
**Best for:** Nature lovers, adventure seekers, sustainable tourism
**Time needed:** 7-10 days (or focus on 1-2 islands)

**Main islands:**
| Island | Highlights |
|--------|------------|
| São Miguel | Largest. Sete Cidades lakes, Furnas hot springs, tea plantation |
| Pico | Pico mountain (Portugal's highest), whale watching, wine |
| Terceira | UNESCO Angra do Heroísmo, caves |
| Faial | Marina, Capelinhos volcano |
| Flores | Waterfalls, remote beauty |

**Character:** Green, volcanic, remote. Whale watching capital. Geothermal cooking (cozido das Furnas). Weather unpredictable — four seasons in one day.

## Planning by Interest

### Wine Focus
1. Douro Valley (Port + table wines)
2. Alentejo (bold reds)
3. Vinho Verde region (fresh whites)
4. Madeira (fortified)

### Beach Focus
1. Algarve (warmest, most beaches)
2. Lisbon coast (Cascais, Arrábida)
3. Alentejo coast (wild, less developed)
4. Porto area (urban beaches)

### Hiking Focus
1. Madeira (levadas)
2. Peneda-Gerês (national park)
3. Azores (volcanic)
4. Serra da Estrela (mountains)
5. Rota Vicentina (coastal)

### History/Culture Focus
1. Lisbon + Sintra
2. Porto
3. Évora
4. Coimbra
5. Guimarães (birthplace of Portugal)

### Off-the-Beaten-Path
1. Aldeias Históricas (Centro)
2. Alentejo interior
3. Trás-os-Montes (remote north)
4. Azores (any island beyond São Miguel)
5. Schist villages (Centro)

## Itinerary Suggestions by Duration

### 1 Week — Classic Portugal
Days 1-3: Lisbon + Sintra
Day 4: Train to Porto
Days 5-6: Porto + Douro day trip
Day 7: Fly out of Porto (or back to Lisbon)

### 1 Week — Beach + Culture
Days 1-2: Lisbon
Day 3: Sintra
Days 4-7: Algarve (Lagos or Tavira)

### 2 Weeks — Comprehensive
Days 1-4: Lisbon, Sintra, Cascais
Day 5: Drive to Évora (Alentejo)
Days 6-7: Évora + wine region
Days 8-10: Algarve
Day 11: Drive/fly to Porto
Days 12-13: Porto
Day 14: Douro day trip

### 1 Week — Islands
**Madeira:** 5-6 days enough for one island
**Azores:** 7 days for São Miguel + Pico, or 5 days São Miguel only

## Getting Between Regions

### Flights
- Lisbon ↔ Porto (1h, cheap with TAP)
- Lisbon ↔ Faro (45 min)
- Lisbon/Porto ↔ Funchal (Madeira)
- Lisbon ↔ Ponta Delgada (Azores)

### Trains
- Lisbon → Porto (3h, Alfa Pendular)
- Lisbon → Faro (2.5h)
- Porto → Braga/Guimarães (1h each)
- Porto → Douro (Régua/Pinhão, scenic)

### Buses
Rede Expressos connects most cities. Cheaper than trains, sometimes faster.

### Car
Recommended for: Alentejo, Algarve (beyond cities), Centro, islands (Madeira/São Miguel)
