# Porto Complete Guide

## Why Porto

Second city, completely different vibe from Lisbon. More reserved, grittier, authentic. Wine caves, francesinha, blue tiles everywhere. Locals are proud, sometimes defensive about not being Lisbon.

## Neighborhoods

### Ribeira (UNESCO)
**Vibe:** Waterfront, colorful houses, tourist central
**Best for:** Photos, first impression, sunset drinks
**Skip:** Eating on the actual waterfront (tourist prices)

**Do:**
- Walk along Cais da Ribeira at sunset
- Cross Dom Luís I bridge for views (upper level)
- Photograph the classic postcard view from Gaia side

### Baixa/Sé
**Vibe:** Historic center, cathedral, train station
**Best for:** Azulejos, churches, São Bento station

**Don't miss:**
- São Bento Station — 20,000 azulejo tiles telling Portuguese history. Free.
- Livraria Lello — Allegedly inspired Harry Potter. €8 to enter (redeemable on books). Go at 9:00 opening or skip.
- Sé Cathedral — Fortress-like, mix of styles, free

### Cedofeita/Bonfim
**Vibe:** Local, young, artsy
**Best for:** Real restaurants, craft beer, avoiding tourists

**Eat here (where locals eat):**
- **Café Candelabro** — Books + coffee, intellectual vibe
- **Padaria Ribeiro** — Classic bakery, no tourists
- **Tapabento** — Small plates, Portuguese ingredients, reasonable

### Foz do Douro
**Vibe:** Beach suburb, wealthy, relaxed
**Best for:** Sunset, beach walk, escape the center
**How:** Tram 1 from Infante, scenic ride along river

**Do:**
- Walk along the promenade at sunset
- Café at Pérgola da Foz
- Continue to Matosinhos for seafood lunch

### Vila Nova de Gaia
**Vibe:** Port wine caves, opposite bank
**Best for:** Cave tours, tastings, views of Porto

**How to get there:** Walk across Dom Luís I bridge (5 min)

**Best caves (not all are equal):**
| Cave | Style | Tour Price | Notes |
|------|-------|-----------|-------|
| Taylor's | Premium | €15-25 | Beautiful gardens, excellent |
| Graham's | Upscale | €15-25 | Stunning views, restaurant |
| Sandeman | Touristy | €13-18 | Famous cape guy, crowded |
| Ramos Pinto | Historic | €12 | Intimate, art nouveau |
| Ferreira | Traditional | €12 | Portuguese-owned |
| Quinta do Noval | Exclusive | €25+ | Best if you're serious |

**Pro tip:** Book ahead for Taylor's and Graham's, especially weekends. Or go to smaller caves like Ramos Pinto — better ratio of experience to crowds.

## The Francesinha — Porto's Pride

This is not a sandwich. It's a heart attack between bread, covered in beer/tomato sauce and cheese.

**What's inside:** Bread, cured ham, sausage, steak, covered in melted cheese, drowned in spiced beer/tomato sauce, usually with a fried egg on top. Served with fries.

**Best francesinhas (locals will fight about this):**
| Place | Address | Price | Notes |
|-------|---------|-------|-------|
| Café Santiago | Rua de Passos Manuel 226 | €12-14 | Classic, most recommended |
| Bufete Fase | Rua do Bonjardim 39 | €10-12 | Old-school, no-frills |
| Capa Negra II | Rua Campo Alegre 191 | €11-13 | Modern version |
| Lado B | Rua de Passos Manuel 190 | €13-15 | Craft beer + francesinha |
| Yuko | Trav. do Carmo 35 | €14-16 | Gourmet version |

**Francesinha rules:**
- Eat for lunch, not dinner (need time to digest)
- Don't order one if you have plans after — food coma guaranteed
- The sauce is the secret — every place has their own
- Don't eat at Ribeira waterfront — tourist versions are sad

## Restaurants — By Category

### Traditional Porto
| Name | Specialty | Price | Address | Notes |
|------|-----------|-------|---------|-------|
| Café Santiago | Francesinha | €12-15 | R. Passos Manuel 226 | The standard |
| Taberna Santo António | Petiscos | €15-20 | Rua das Virtudes 32 | Local gem |
| Tapabento | Modern Portuguese | €20-30 | Rua da Madeira 222 | Book ahead |
| Casa Nanda | Fish | €15-25 | Rua do Almada 137 | Simple, excellent |

### Seafood (Go to Matosinhos)
Skip Porto center for fish. Take metro to Matosinhos (20 min). Walk to Rua Heróis de França — entire street of seafood restaurants.

| Name | Specialty | Price | Notes |
|------|-----------|-------|-------|
| Casa de Chá da Boa Nova | 2 Michelin stars | €200+ | Álvaro Siza building, ocean views |
| O Valentim | Grilled fish | €15-25 | No reservations, queue |
| Pipo | Fish | €18-30 | Classic, reliable |

### Fine Dining
| Name | Stars | Price | Notes |
|------|-------|-------|-------|
| Casa de Chá da Boa Nova | 2 | €200+ | Worth the trip to Matosinhos |
| The Yeatman | 2 | €180+ | Wine hotel, Gaia views |
| Antiqvvm | 1 | €80-120 | In Jardim do Palácio de Cristal |
| Pedro Lemos | 1 | €80-120 | Refined, local ingredients |

### Vegetarian
Less options than Lisbon, but growing:
- **daTerra** — Buffet, vegan, €10-15, Rua de Mouzinho da Silveira 249
- **Essência** — Vegetarian, €12-18, Rua de Pedro Hispano 1190

## Day Trips from Porto

### Douro Valley — Wine Country
**Why:** UNESCO valley, terraced vineyards, quintas, port wine
**How:** Train from São Bento to Pinhão (3h, €14, scenic), or day tour
**When:** Best in September-October (harvest)

**Quintas to visit:**
- **Quinta do Crasto** — Stunning views, excellent wines, book lunch
- **Quinta Nova** — Wine hotel, meals, accessible
- **Quinta do Vallado** — Family-owned, intimate

**Pro tip:** The train ride is as scenic as the destination. Sit on the right side going east.

### Guimarães — Birthplace of Portugal
**Why:** Medieval center, where Portugal was born
**How:** Train from Porto (1h15, €3.50)
**Do:** Paço dos Duques, old town, lunch at Historico by Papaboa

### Braga — Religious Capital
**Why:** Baroque churches, Bom Jesus sanctuary
**How:** Train (1h, €3.50)
**Do:** Climb Bom Jesus stairs, old town

### Aveiro — Portuguese Venice
**Why:** Canals, moliceiros boats, ovos moles
**How:** Train (1h, €4)
**Do:** Canal cruise, eat ovos moles

## Views & Photos

| Spot | Best for | Notes |
|------|----------|-------|
| Jardim do Morro | Sunset | Gaia side, bring wine |
| Dom Luís I bridge | Iconic view | Upper level, free |
| Serra do Pilar | Classic panorama | Gaia, next to bridge |
| Clérigos Tower | City view | €6, climb 225 steps |
| Palácio de Cristal | Sunset, gardens | Peaceful, locals picnic |

## Getting Around

### From Airport
- **Metro** — Line E (violet) to Trindade, then where needed. €2.60, 30 min.
- **Uber/Bolt** — €15-20 to center

### In Porto
- **Walking** — Best option. Center is compact but hilly.
- **Metro** — Clean, useful for Matosinhos, Gaia, airport
- **Historic Tram** — Lines 1 (Foz), 18, 22. Scenic, not practical.
- **Uber/Bolt** — €5-10 most trips

### Porto Card
Usually NOT worth it unless doing many museums. Metro is cheap, most churches free.

## Porto Mistakes to Avoid

1. **Eating on Ribeira waterfront** — Tourist prices, mediocre food
2. **Livraria Lello without booking** — Queue is insane. Book online or skip.
3. **Only visiting Sandeman** — Touristy. Taylor's, Graham's, Ramos Pinto better.
4. **Skipping Matosinhos** — Best seafood is there, not in center
5. **Expecting Lisbon vibe** — Porto is different. Embrace the grittiness.
6. **Francesinha for dinner** — Too heavy. Lunch, always.
