# Portuguese Food Guide

## The Philosophy

Portuguese food is simple, honest, and fish-obsessed. Not fancy—grandma's cooking elevated. Fresh ingredients, minimal fuss, generous portions. If someone says they have 365 recipes for bacalhau (salt cod), they're not exaggerating.

## Essential Dishes

### Seafood
| Dish | What | When/Where |
|------|------|------------|
| **Bacalhau à Brás** | Shredded salt cod, eggs, fried potatoes, olives | Everywhere, comfort food classic |
| **Bacalhau com natas** | Salt cod gratin with cream | Rich, heavy, Porto specialty |
| **Polvo à lagareiro** | Octopus with garlic, olive oil, baked potatoes | Order everywhere near coast |
| **Arroz de marisco** | Seafood rice, soupy | Share with group, €20-30 |
| **Cataplana** | Copper pot seafood stew | Algarve specialty |
| **Percebes** | Goose barnacles | Expensive (€30-50/kg), delicacy |
| **Amêijoas à Bulhão Pato** | Clams, garlic, cilantro, white wine | Simple, perfect starter |
| **Caldeirada** | Fish stew, fisherman style | Coastal, varies by region |
| **Sardinhas assadas** | Grilled sardines | June especially (Santos Populares) |

### Meat
| Dish | What | When/Where |
|------|------|------------|
| **Cozido à portuguesa** | Boiled meats, vegetables, sausages | Winter, heavy, traditional |
| **Leitão da Bairrada** | Suckling pig | Near Coimbra, specialty |
| **Alheira** | Bread sausage (originally Jewish) | Trás-os-Montes, grilled |
| **Francesinha** | Meat/cheese/sauce sandwich | Porto ONLY |
| **Secretos de porco preto** | Iberian black pig cuts | Alentejo specialty |
| **Feijoada** | Bean and meat stew | Hearty, winter |
| **Tripas à moda do Porto** | Tripe Porto-style | If you're adventurous |

### Petiscos (Portuguese Tapas)
Small plates for sharing. Order 3-4 per person.

| Petisco | What | Price |
|---------|------|-------|
| Peixinhos da horta | Fried green beans (tempura origin) | €5-7 |
| Croquetes | Croquettes, beef | €4-6 |
| Rissóis | Shrimp or meat half-moon pastries | €3-5 |
| Pataniscas | Cod fritters | €5-7 |
| Presunto | Cured ham (Iberian quality) | €10-15 |
| Queijo da Serra | Mountain sheep cheese | €8-12 |
| Prego | Steak sandwich | €5-8 |

### Pastries & Sweets
| Sweet | What | Where |
|-------|------|-------|
| **Pastel de nata** | Custard tart, crispy shell | Everywhere (Manteigaria best) |
| **Travesseiros** | Almond pillow pastry | Sintra (Piriquita) |
| **Queijadas** | Cheese pastries | Sintra |
| **Ovos moles** | Sweet egg yolk in wafer | Aveiro |
| **Pastéis de Tentúgal** | Crispy phyllo with egg cream | Near Coimbra |
| **Toucinho do céu** | Almond cake | Norte |
| **Serradura** | Sawdust pudding (cream + biscuit) | Macau origin, everywhere |

## Regional Differences

### Lisbon
- Petiscos culture (sharing)
- Ginjinha (sour cherry liqueur)
- Bifanas (pork sandwiches)
- Seafood from Cascais/Sesimbra

### Porto
- Francesinha (nowhere else does it right)
- Tripas à moda do Porto
- More meat-heavy than Lisbon
- Heavier, richer flavors

### Alentejo
- Porco preto (black pig)
- Açorda (bread soup)
- Best olive oil
- Wines: bold reds

### Algarve
- Cataplana (copper pot stew)
- Fresh fish everywhere
- Percebes
- Lighter, Mediterranean influence

### Açores
- Cozido das Furnas (cooked underground)
- Pineapple, tea, cheese
- Unique volcanic terroir

### Madeira
- Espetada (beef skewers)
- Bolo de mel (honey cake)
- Black scabbard fish
- Poncha (rum drink)

## How to Eat Like a Local

### Timing
- **Lunch:** 12:30-15:00 (main meal for many)
- **Dinner:** 20:00-22:00 (kitchens open around 19:30)
- **Late dinner:** Normal, especially weekends

### The Meal Structure
1. **Couvert** — Bread, butter, olives, sometimes cheese/paté. NOT free. €2-5. Refuse if you don't want to pay.
2. **Entrada** — Starter, often soup (caldo verde)
3. **Prato principal** — Main course
4. **Sobremesa** — Dessert (often skipped)
5. **Café** — Espresso. Always. €0.70-1.00.

### Coffee Culture
| Order | What you get |
|-------|-------------|
| Um café | Espresso (bica in Lisbon, cimbalino in Porto) |
| Café cheio | Fuller espresso |
| Café duplo | Double espresso |
| Meia de leite | Half coffee, half milk |
| Galão | Tall glass, more milk |
| Abatanado | Longer espresso (like americano) |

**Price:** At bar €0.70-1.00. At table €1.50-2.50. Standing is local.

### Tipping
- Not expected like USA
- Round up or 5-10% if excellent
- Nicer restaurants: 10%
- Already included in some tourist areas

### Wine at Meals
Wine is cheap and expected. House wine (vinho da casa) is €2-5 per carafe and often good. See wine.md for regions.

## Best Restaurants by City

### Lisbon Top 5
1. **Cervejaria Ramiro** — Seafood, worth the hype, €40-60
2. **Taberna da Rua das Flores** — Petiscos, intimate, €20-30
3. **Belcanto** — 2 Michelin stars, €200+
4. **O Velho Eurico** — Cheap lunch, authentic, €8-12
5. **Ponto Final** — Cacilhas, fish with sunset view, €20-30

### Porto Top 5
1. **Café Santiago** — Francesinha standard, €12-15
2. **Casa de Chá da Boa Nova** — 2 stars, ocean views, €200+
3. **Taberna Santo António** — Petiscos, local vibe, €15-20
4. **O Valentim** (Matosinhos) — Fish, worth the queue, €15-25
5. **Tapabento** — Modern Portuguese, €20-30

### Outside Cities
- **Leitão Zé dos Leitões** (Mealhada) — Suckling pig pilgrimage
- **DOC** (Douro) — Riverside, Rui Paula, €80-120
- **Fortaleza do Guincho** — Near Cascais, 1 star, €100+

## Food Tourist Traps

1. **Pastel de Belém queue** — Same recipe at Manteigaria, no wait
2. **Restaurants with hawkers** — Beckoning = avoid
3. **Photos on menus** — Usually bad sign
4. **"Traditional seafood" on Ribeira/Rua Augusta** — Tourist prices
5. **Couvert you didn't order** — It's not free, you can refuse
6. **"Best cataplana" signs in Algarve** — Usually worst

## Vegetarian Survival Guide

Portugal is meat/fish heavy, but improving:

### What to Order
- Soup (caldo verde without chouriço)
- Petiscos: peixinhos da horta, salada, queijo
- Açorda without meat
- Omelette (omelete)
- Specify "sem carne, sem peixe"

### Best Vegetarian Restaurants
- **Ao 26** (Lisbon) — Vegan fine dining
- **The Food Temple** (Lisbon) — Vegan
- **daTerra** (Porto) — Buffet
- **Os Tibetanos** (Lisbon) — Buddhist, vegetarian

### Warning
"Vegetarian" sometimes means "has vegetables" to older Portuguese. Be explicit.
