# Emergencies & Safety in Portugal

## Emergency Numbers

| Service | Number | Notes |
|---------|--------|-------|
| **Universal Emergency** | **112** | Police, Fire, Ambulance |
| SOS Highway | 117 | Breakdown, accidents |
| Tourist Police | 808 200 200 | English available |
| Poison Control | 808 250 143 | 24h |
| PSP (Urban Police) | Local varies | Non-emergency |
| GNR (Rural Police) | Local varies | Non-emergency |

**112 works from any phone, even without SIM**

## Safety Overview

### Portugal is Very Safe
- 6th safest country in the world (2024 Global Peace Index)
- Violent crime rare
- Guns rare
- Terrorism risk very low

### Main Concerns
1. **Pickpocketing** — Tourist areas (Tram 28, Bairro Alto, Alfama)
2. **Car break-ins** — Don't leave valuables visible
3. **Scams** — Standard tourist scams exist
4. **Beach safety** — Atlantic currents, cold water

## Common Scams to Avoid

### Pickpockets
**Where:** Tram 28, Bairro Alto at night, crowded tourist spots
**Prevention:**
- Front pocket or money belt for valuables
- Don't flash expensive phones/cameras
- Watch bags in crowded areas

### Street "Gifts"
**What:** Someone offers "free" bracelet/flower, demands money
**Prevention:** Firmly say "não, obrigado" and keep walking

### Fake Petitions
**What:** Someone asks you to sign petition, then asks for money
**Prevention:** Don't engage

### Restaurant Couvert Surprise
**What:** Bread/olives placed on table, charged €5-10 unexpectedly
**Prevention:** Ask if it costs before eating, or refuse

### Taxi Scams
**What:** Long routes, "broken" meter
**Prevention:** Use Uber/Bolt (price locked), or insist on meter

### Drug Dealers
**What:** Aggressive offers in Bairro Alto, Rossio
**Prevention:** Firmly decline, keep walking. Often selling fake drugs anyway.

## Health

### Healthcare Quality
Good. Public and private hospitals meet European standards.

### EHIC/GHIC Card
If from EU/UK: Bring your European Health Insurance Card. Covers emergency public healthcare.

### Travel Insurance
**Highly recommended** even with EHIC:
- Private hospitals
- Repatriation
- Non-emergency care
- Stolen belongings

### Pharmacies
- **Farmácia** — Green cross sign
- Pharmacists helpful, can recommend for minor issues
- Some medications (antibiotics) require prescription

### Finding Medical Help
- **Minor issues:** Pharmacy first
- **Urgent:** Hospital urgências (A&E)
- **Private clinics:** Faster, English common

### Hospitals (English Likely)
**Lisbon:**
- Hospital de Santa Maria (public, large)
- Hospital CUF Descobertas (private)
- British Hospital (private, English)

**Porto:**
- Hospital de São João (public, large)
- Hospital da CUF Porto (private)

**Algarve:**
- Hospital de Faro (public)
- Hospital Particular do Algarve (private)

### Dental
Dentists available. Usually private. €50-100 for consultation.

### COVID & Vaccinations
- No COVID restrictions (as of 2024)
- No special vaccinations required
- EU Digital COVID Certificate no longer required

## Water Safety

### Tap Water
**Safe everywhere.** No need for bottled water (though locals often drink bottled).

### Beach Safety
**Atlantic Ocean = respect required**

**Flags:**
- 🟢 Green: Safe to swim
- 🟡 Yellow: Caution, some danger
- 🔴 Red: No swimming
- 🏴 Black: Beach closed
- 🏁 Checkered: Lifeguards absent

**Currents:** Rip currents exist. Swim parallel to shore if caught.

**Water temperature:** 17-22°C even in summer. Cold shock possible.

**Lifeguards:** Blue flag beaches staffed June-September

## Natural Hazards

### Heat
**Summer:** Can exceed 40°C inland (Alentejo, interior)
- Hydrate
- Avoid midday sun (12-16h)
- Sunscreen essential

### Wildfires
**August-September risk.** Usually not tourist areas.
- Follow local news
- Don't throw cigarette butts
- If smoke heavy: stay indoors, drive carefully

### Jellyfish
Occasional, usually not dangerous Portuguese man o' war (caravela portuguesa) rare but serious. Seek help if stung.

### Earthquakes
Portugal is seismically active (1755 Lisbon earthquake).
- Modern buildings earthquake-resistant
- Risk very low but exists
- In earthquake: Drop, Cover, Hold On

## Consulates

### Lisbon
- **US:** Av. das Forças Armadas
- **UK:** Rua de São Bernardo 33
- **Canada:** Av. da Liberdade 198-200
- **Australia:** Via UK consulate
- **Ireland:** Rua da Imprensa à Estrela 1-4

### Porto
- **UK:** Av. da Boavista 3072
- **US:** Via Lisbon

### Faro
Limited consular presence. Contact Lisbon.

## Lost/Stolen Items

### Passport Lost
1. Report to police (get report number)
2. Contact embassy/consulate
3. Emergency travel document issued

### Credit Cards Lost
1. Call bank immediately to block
2. Report to police
3. Keep report for insurance

### Phone Lost
1. Try Find My iPhone/Android
2. Block SIM (call provider)
3. Report to police for insurance
4. Change passwords (email, banking)

### Police Report
For insurance claims, you need a "Participação" (police report).
- Can file at any PSP station
- Tourist police may have English speakers
- Can take several hours

## LGBTQ+ Safety

**Portugal is very LGBTQ+-friendly:**
- Same-sex marriage legal since 2010
- Strong anti-discrimination laws
- Lisbon has large LGBTQ+ scene (Príncipe Real)
- Pride events in major cities

**No significant safety concerns** for LGBTQ+ travelers.

## Solo Female Travel

**Portugal is safe for solo female travelers:**
- Normal urban awareness applies
- Nightlife areas (Bairro Alto) can be pushy but not dangerous
- Public transport safe
- Beaches safe

**Standard precautions:** Tell someone your plans, avoid walking alone very late in isolated areas.

## Drug Policy

**Portugal decriminalized personal drug use in 2001.**
- Still illegal to possess/buy
- Not prosecuted as criminal if small personal amounts
- Dealers prosecuted
- Tourist advice: Don't buy from street dealers (often scams anyway)

## Travel Advisories

Check before travel:
- **US:** travel.state.gov
- **UK:** gov.uk/foreign-travel-advice
- **Canada:** travel.gc.ca
- **Australia:** smartraveller.gov.au

Currently: Portugal has no significant advisories.
