# Portuguese Beach Guide

## Know Before You Go

### Water Temperature
**Atlantic = COLD.** Even in August:
- Lisbon coast: 17-20°C
- Algarve: 20-23°C (warmest)
- North: 15-18°C

**Translation:** Refreshing dip, not lounging in water. Wetsuits common for surfing year-round.

### Beach Culture
- **Sunbeds:** €10-20/day at beach bars (not everywhere)
- **Food:** Beach restaurants (better than expected)
- **Nudist:** Some sections, usually marked
- **Lifeguards:** Blue flag beaches staffed in summer
- **Dogs:** Often banned June-September

## Beaches by Region

### Lisbon Area

#### Costa da Caparica
**What:** Long strip of beaches south of Lisbon. Surfers, families, young crowd.
**How:** Bus from Praça Espanha (45 min) or ferry to Cacilhas + bus
**Vibe:** More relaxed than Cascais, local, good waves

Best beaches:
- **Praia de São João** — Young crowd, bars
- **Praia da Morena** — LGBTQ+ friendly
- **Praia do Meco** — Wilder, naturist section

#### Cascais/Estoril
**What:** Train-accessible beach towns
**How:** Train from Cais do Sodré (40 min, €2.25)
**Vibe:** Tourist, family, crowded in summer

**Beaches:**
- Praia de Carcavelos — Biggest, surfing
- Praia da Rainha — Small, central Cascais
- Praia do Tamariz — Estoril, casino backdrop

#### Guincho
**What:** Wild beach, big waves, wind
**How:** Need car from Cascais
**Vibe:** Surfers, kiters, dramatic

#### Arrábida
**What:** Crystal clear water, protected nature park
**How:** Need car from Lisbon (1 hour)
**Vibe:** Best water near Lisbon, Mediterranean feel

**Best beaches:**
- **Praia de Galapinhos** — Voted best beach in Europe (2017), limited access
- **Praia de Figueirinha** — More accessible
- **Praia de Coelhos** — Tiny, hidden

**Pro tip:** Arrive before 10:00 in summer. Park closes when full.

### Porto Area

#### Matosinhos
**What:** Urban beach, seafood restaurants behind
**How:** Metro from Porto (20 min)
**Vibe:** Local, surfing, lunch destination

#### Foz do Douro
**What:** Porto's beach neighborhood
**How:** Tram 1 from center or walk
**Vibe:** Upscale, sunset walks, rocky

#### Espinho
**What:** Proper beach town south of Porto
**How:** Train (30 min)
**Vibe:** Local holiday spot, casino

### Algarve

#### Western Algarve (Best cliffs)
| Beach | Near | Notes |
|-------|------|-------|
| Praia da Marinha | Lagoa | Iconic cliffs, snorkeling, crowded |
| Praia de Benagil | Lagoa | Cave access by water |
| Praia Dona Ana | Lagos | Postcard perfect, small |
| Praia do Camilo | Lagos | 200 steps down, dramatic |
| Praia da Rocha | Portimão | Big, tourist, facilities |

#### Eastern Algarve (Calmer)
| Beach | Near | Notes |
|-------|------|-------|
| Ilha de Tavira | Tavira | Ferry access, pristine |
| Praia de Cabanas | Cabanas | Village vibe |
| Cacela Velha | Near Tavira | Lagoon, peaceful |
| Ilha Deserta | Faro | Boat access, wild |

#### Secret Spots
- **Praia da Ingrina** — Near Sagres, tiny, locals
- **Praia da Arrifana** — Surf, dramatic, north Algarve

### West Coast (Wild Atlantic)

#### Costa Vicentina
**What:** Protected coastline, surfing, wild
**Where:** Alentejo coast down to Sagres
**Vibe:** Undeveloped, dramatic, windswept

**Best beaches:**
- **Praia de Odeceixe** — River meets sea
- **Praia da Amoreira** — Dunes, lagoon
- **Praia da Bordeira** — Huge, wild
- **Praia do Amado** — Surf mecca

### Islands

#### Madeira
**No sandy beaches.** Volcanic island = pebbles and rocks. Natural lava pools instead:
- Porto Moniz — Famous natural pools
- Prainha — One sandy beach (black sand), tiny

#### Azores
Mix of volcanic and some sandy beaches:
- **Praia de Santa Bárbara** (São Miguel) — Surf beach
- **Praia Formosa** (Santa Maria) — Best sand in Azores

## Beaches by Activity

### Surfing
| Beach | Level | Notes |
|-------|-------|-------|
| Ericeira | All levels | WSL reserve, world-class |
| Peniche/Supertubos | Expert | Pipeline of Europe |
| Nazaré | Expert only | Big wave, winter |
| Praia do Amado | All levels | Consistent, schools |
| Carcavelos | Beginner | Near Lisbon, easy |
| Matosinhos | Beginner | Near Porto |

### Families
- Praia da Falésia (Algarve) — Long, facilities
- Cascais beaches — Train access, calm
- Praia de São Jacinto (Aveiro area) — Protected lagoon
- Ilha de Tavira — Calm, shallow

### Hidden/Quiet
- Praia de Galapinhos (Arrábida) — Limited access
- Cacela Velha (Algarve) — Lagoon
- Praia da Adraga (Sintra coast) — Dramatic, local
- Praia dos Coelhos (Arrábida) — Tiny cove

### Nudist
- Praia do Meco (Costa da Caparica) — Section
- Praia das Adegas (Alentejo) — Remote
- Ilha Deserta (Faro) — Section

## Surf Towns

### Ericeira
**What:** World Surfing Reserve (one of few globally)
**Where:** 35 km north of Lisbon
**Vibe:** Surf culture, hostels, relaxed

**Waves:** 7+ breaks including Ribeira d'Ilhas, Coxos (expert)
**Schools:** Everywhere, €30-50/lesson
**Stay:** Hostels €20-30, surf camps €50-100

### Peniche
**What:** Surf peninsula, Supertubos (world tour)
**Where:** 1 hour north of Lisbon
**Vibe:** Working fishing town + surf

**Waves:** Supertubos (expert), Baleal (learners)
**Also:** Boat to Berlengas islands (nature reserve)

### Nazaré
**What:** Big wave surfing capital
**When:** Winter storms = 20-30m waves
**Watch from:** Farol da Nazaré (lighthouse viewpoint)

**For non-surfers:** Traditional fishing culture, funicular, great seafood

## Beach Essentials

### What to Bring
- Windbreak/tent — Atlantic wind is real
- Reef shoes — Some beaches rocky
- Sunscreen — Sun is strong
- Cash — Beach bars often cash-only
- Light cover-up — For lunch at beach restaurants

### Blue Flag Beaches
Quality standard. Portugal has 400+ Blue Flag beaches (one of highest in Europe). Indicates:
- Water quality
- Lifeguards
- Facilities
- Environmental management

## Beach Mistakes

1. **Expecting warm water** — It's the Atlantic. Bring wetsuit or accept cold dips.
2. **No sunscreen because "not tropical"** — UV index high, especially Algarve
3. **Driving to Arrábida after 11:00 in summer** — Park closes when full
4. **Beach restaurant at 14:00** — Packed. Go 12:30 or after 15:00.
5. **Sintra coast without checking conditions** — Rough, dangerous currents
6. **Underestimating Nazaré waves** — Only watch from shore. Never swim in big wave conditions.
