# Essential Apps for Portugal

## Transport

### Uber / Bolt
**What:** Ride-hailing
**Works in:** Lisbon, Porto, Algarve, Madeira
**Cost:** Cheaper than taxis, €5-15 most trips
**Tip:** Bolt often slightly cheaper than Uber

### Carris / STCP
**What:** Official public transport apps
**Carris:** Lisbon buses, trams, metro
**STCP:** Porto buses, metro
**Use for:** Route planning, schedules
**Alternative:** Google Maps works well for transit

### CP (Comboios de Portugal)
**What:** Train booking app
**Use for:** Book tickets, check schedules
**Alternative:** cp.pt website
**Tip:** Book Alfa Pendular (fast trains) in advance for better prices

### Rede Expressos
**What:** Bus network
**Use for:** Intercity buses (often cheaper than trains)
**Alternative:** rede-expressos.pt

### Via Verde Visitors
**What:** Toll payment (essential if driving)
**Why:** Portuguese tolls are electronic (no booths)
**Alternative:** Rent Via Verde device with car rental
**Cost:** App requires registration + €6 device mailed to accommodation

## Food & Restaurants

### Zomato
**What:** Restaurant reviews, menus
**Coverage:** Good in Lisbon and Porto
**Tip:** Better for urban areas than TripAdvisor sometimes

### TheFork (LaFourchette)
**What:** Restaurant reservations, discounts
**Use for:** Book popular restaurants, get 20-50% off
**Coverage:** Major cities

### Google Maps
**What:** Best for reviews + discovery
**Tip:** Search "petiscos" or "tasca" for local gems

### Bolt Food / Uber Eats / Glovo
**What:** Food delivery
**Coverage:** Lisbon, Porto, Algarve
**Tip:** Glovo sometimes has local restaurants others don't

## Navigation & Maps

### Google Maps
**What:** Navigation, transit, reviews
**Works:** Everywhere, offline maps available
**Best for:** Most situations

### maps.me
**What:** Offline maps
**Best for:** Hiking, rural areas, islands
**Tip:** Download before going offline

### Wikiloc
**What:** Trail maps, GPS tracks
**Best for:** Hiking routes (Rota Vicentina, Madeira levadas)
**Tip:** Premium worth it for offline + navigation

### Komoot
**What:** Route planning, hiking/cycling
**Alternative to:** Wikiloc for planning

## Money & Payments

### Revolut / Wise / N26
**What:** Multi-currency accounts, cheap conversion
**Why:** Better rates than banks, no foreign transaction fees
**Tip:** Widely accepted, use for larger purchases

### MB Way
**What:** Portuguese mobile payment system
**Works with:** Portuguese bank accounts only
**For tourists:** Not usable, but good to know what locals use

### Apple Pay / Google Pay
**What:** Contactless payments
**Coverage:** Most restaurants, shops, supermarkets accept
**Tip:** Very widely accepted in Portugal

## Language

### Google Translate
**What:** Translation + camera mode
**Use for:** Menus, signs, basic conversations
**Tip:** Download Portuguese for offline use

### Duolingo
**What:** Language learning
**Use for:** Basic Portuguese before/during trip
**Realistic:** Learn greetings and food words

## Accommodation

### Booking.com
**What:** Best hotel coverage in Portugal
**Tip:** Free cancellation options useful

### Airbnb
**What:** Apartments, unique stays
**Note:** Legal in Portugal (look for AL license)

## Activities & Experiences

### GetYourGuide / Viator
**What:** Tours, activities, skip-the-line tickets
**Use for:** Popular attractions (Sintra, Port caves)
**Tip:** Book Sintra tickets here to skip queues

### Fever
**What:** Local events, experiences
**Coverage:** Lisbon mainly
**Use for:** Rooftop events, unique experiences

## Utilities

### Waze
**What:** Navigation with traffic, speed cameras
**Best for:** Driving, especially Algarve
**Tip:** Better than Google Maps for traffic alerts

### WhatsApp
**What:** Messaging
**Why:** Portuguese default messaging app
**Use for:** Contact restaurants, tour operators, hosts

### XE Currency
**What:** Currency conversion
**Use for:** Quick price checks
**Tip:** Most things in Portugal are in euros anyway

## Portugal-Specific

### EMEL Parking (Lisbon)
**What:** Pay for street parking
**Use for:** If you're driving in Lisbon (avoid if possible)

### Visitante EMEL
**What:** Lisbon parking app
**Alternative:** ePark app

### Time Out
**What:** Local events, restaurants
**Coverage:** Lisbon and Porto editions
**Use for:** What's on, new openings

## Travel Planning

### Trainline
**What:** European train booking
**Use for:** Cross-border or multi-country trips
**Alternative:** cp.pt for Portugal-only

### Skyscanner
**What:** Flight search
**Use for:** Inter-island flights (Azores), Madeira connections
**Tip:** TAP often cheapest for domestic

### PackPoint
**What:** Packing list generator
**Use for:** Weather-appropriate packing

## Essential Downloads Before Arriving

1. **Google Maps** — Download Portugal offline maps
2. **Uber + Bolt** — Set up accounts
3. **Booking.com** — Confirmations accessible offline
4. **WhatsApp** — Communication with locals
5. **Translator** — Download Portuguese language
6. **Wikiloc** — If hiking, download trail maps

## Apps to Skip

- **TripAdvisor** — Google Maps reviews usually better in Portugal
- **Yelp** — Not used in Portugal
- **Citymapper** — Doesn't cover Portugal well
- **Local taxi apps** — Just use Uber/Bolt
