#!/usr/bin/env python3
import re
import sys
from datetime import datetime
import os

# Read holdings from references/portfolio-holdings.md
with open(os.path.join(os.path.dirname(__file__), '../references/portfolio-holdings.md'), 'r') as f:
    holdings_text = f.read()

# Parse tickers and shares (simple regex)
stocks = re.findall(r'([A-Z]+):\\s*([0-9.]+)', holdings_text)
crypto = re.findall(r'([A-Z]+):\\s*([0-9.]+)', holdings_text, re.MULTILINE)

print('Holdings parsed. Ready for browser data input.')
print('stocks:', stocks[:5])  # Sample
print('crypto:', crypto)