---
name: portfolio-tracker
description: Automates live portfolio tracking and analysis using browser automation on Yahoo Finance. Fetches real-time prices for Vish's 27 stocks/ETFs + 4 cryptos, updates portfolio-tracker.md, generates performance summaries, winners/losers, rebalancing suggestions, and market news. Use for: portfolio value checks, performance analysis, daily/heartbeat updates, averaging opportunities, or when user mentions stocks, portfolio, investments, or market updates.
---

# Portfolio Tracker

## Quick Start
Run `portfolio update` or ask \"update my portfolio\" to fetch live prices via browser and generate analysis.

## Workflow
1. **Read holdings** from `references/portfolio-holdings.md`
2. **Browser automation**: Attach Chrome extension (profile=open-claw-chrome) to Yahoo Finance
3. **Fetch prices**: Snapshot ticker pages or portfolio view
4. **Update portfolio-tracker.md** with new values/performance
5. **Generate analysis**: Winners/losers, total value, suggestions

## Update Portfolio
```
1. browser action=tabs profile=open-claw-chrome (attach Yahoo Finance tab)
2. For each ticker in holdings:
   - browser navigate https://finance.yahoo.com/quote/[TICKER]
   - browser snapshot refs=aria (extract price, change, %change)
3. Parse snapshots, calculate values (shares * price)
4. edit portfolio-tracker.md with new table
5. Add analysis section (winners/losers, market summary)
```

**Crypto**: Use https://finance.yahoo.com/quote/BTC-USD etc.

## Analysis Patterns
- **Winners/Losers**: Top 5 +5% / -5%
- **Concentration Risk**: Flag if any position >15% total
- **Market Context**: S&P500/Nasdaq from ^GSPC/^IXIC snapshots
- **Suggestions**: Beaten-down positions (< -5% today)

## Structuring This Skill

[TODO: Choose the structure that best fits this skill's purpose. Common patterns:

**1. Workflow-Based** (best for sequential processes)
- Works well when there are clear step-by-step procedures
- Example: DOCX skill with "Workflow Decision Tree" -> "Reading" -> "Creating" -> "Editing"
- Structure: ## Overview -> ## Workflow Decision Tree -> ## Step 1 -> ## Step 2...

**2. Task-Based** (best for tool collections)
- Works well when the skill offers different operations/capabilities
- Example: PDF skill with "Quick Start" -> "Merge PDFs" -> "Split PDFs" -> "Extract Text"
- Structure: ## Overview -> ## Quick Start -> ## Task Category 1 -> ## Task Category 2...

**3. Reference/Guidelines** (best for standards or specifications)
- Works well for brand guidelines, coding standards, or requirements
- Example: Brand styling with "Brand Guidelines" -> "Colors" -> "Typography" -> "Features"
- Structure: ## Overview -> ## Guidelines -> ## Specifications -> ## Usage...

**4. Capabilities-Based** (best for integrated systems)
- Works well when the skill provides multiple interrelated features
- Example: Product Management with "Core Capabilities" -> numbered capability list
- Structure: ## Overview -> ## Core Capabilities -> ### 1. Feature -> ### 2. Feature...

Patterns can be mixed and matched as needed. Most skills combine patterns (e.g., start with task-based, add workflow for complex operations).

Delete this entire "Structuring This Skill" section when done - it's just guidance.]

## [TODO: Replace with the first main section based on chosen structure]

[TODO: Add content here. See examples in existing skills:
- Code samples for technical skills
- Decision trees for complex workflows
- Concrete examples with realistic user requests
- References to scripts/templates/references as needed]

## Resources

### references/portfolio-holdings.md
Vish's exact holdings (shares/amounts). Update manually when buying/selling.

### scripts/update-portfolio.py
Parses holdings, processes browser data (future: full automation).
