# Portfolio Risk & Optimization Analyzer

**Turn portfolio analysis fees into $BANKR buy pressure** 🤖💰

## What is This?

An AI-powered crypto portfolio risk analyzer that:
1. Scans wallets and calculates risk scores
2. Requires payment ($5 per scan) OR holding 1000+ $BANKR tokens
3. **Automatically swaps 100% of fees to buy back $BANKR**
4. Creates constant buy pressure on the token

## Quick Start

```bash
# Install
clawdhub install portfolio-risk-analyzer
cd skills/portfolio-risk-analyzer
npm install

# Configure
cp .env.example .env
# Add your RPC endpoints and API keys

# Analyze a wallet
./scripts/analyze-wallet.sh 0xYourWallet

# Start API server
npm start

# Manual buyback
./scripts/execute-buyback.sh
```

## Pricing

- **$5 per scan** (one-time)
- **FREE for BANKR holders** (≥1000 tokens)
- 100% of fees → Uniswap → $BANKR buyback

## Token Address

$BANKR: `0x50D2280441372486BeecdD328c1854743EBaCb07`

## Features

- 📊 Multi-chain portfolio scanning
- ⚠️ Risk scoring (0-100)
- 💡 Optimization recommendations
- 🔄 Automated buyback every hour
- 🎙️ Voice bot integration (optional)
- 📈 Real-time DeFi position tracking

## How It Works

1. User pays $5 USDC (or holds 1000+ BANKR)
2. AI scans wallet across chains
3. Calculates risk score & generates recommendations
4. Fee is collected in USDC
5. **Every hour: USDC → BANKR via Uniswap**
6. Buy pressure + token burns/distribution

## Monetization Example

- 100 scans/day = $500/day revenue
- $500 USDC → ~62,500 BANKR tokens (at $0.008)
- $15,000/month buy pressure
- Self-sustaining token economy

## Why This Rocks

- **Utility** = Real problem solved (risk management)
- **Revenue** = Instant monetization
- **Tokenomics** = Buy pressure drives price up
- **Holders** = Get free access (incentive to hold)
- **Growth** = More users = more buybacks = higher price

## Documentation

See [SKILL.md](SKILL.md) for full documentation.

## License

MIT
