# Strategy reference (BTC 1h Up/Down)

## Resolution anchor
These markets resolve by **Binance BTCUSDT 1H candle**: close vs open.
Use Binance as the only ground-truth signal.

## Fair probability model (simple, robust)

Inputs:
- `open_px`: exact Binance 1H candle open at the hour boundary
- `spot`: current BTCUSDT spot
- `sigma_1m`: stdev of 1m returns over lookback window (e.g. 30–60m)
- `minutes_left`

Compute:
- `cur_ret = (spot-open_px)/open_px`
- `stdev = sigma_1m * sqrt(minutes_left)`
- `z = cur_ret / stdev`
- `p_up = Phi(z)`

Then:
- `fair_up = p_up`
- `fair_down = 1 - p_up`

Interpretation:
- `|z|` is confidence. Large |z| means the remaining time is unlikely to flip the sign.

## Edge / mispricing
Approximate expected value per $1 payout token:
- `edge_up = fair_up - price_up`
- `edge_down = fair_down - price_down`

Enter only when best edge exceeds a minimum:
- `EDGE_MIN` (start ~0.06, tune)

## Guardrails (mandatory)

### Directional guardrail
If `abs(z) >= z_guard` (start 0.25):
- if `z>0`: do not enter Down
- if `z<0`: do not enter Up

### Churn control
- cap round-trips per market: `MAX_TRADES_PER_MARKET` (start 1–2)
- add cooldown after exit; longer cooldown after stops.

## Exit management

### For model entries
- **Hold to preclose** if confidence is extreme and aligned:
  - Up and `z >= Z_HOLD` (start 2.5)
  - Down and `z <= -Z_HOLD`

- Otherwise take profit / cut using edge:
  - take profit if market bid >= `fair + EDGE_EXIT`
  - cut if model flips materially against you (define via fair crossing below 0.5-margin)

### For mean-reversion entries
Do NOT use model_tp. Use only:
- profit target / trailing
- regime flip stop

## Tuning checklist
1) Verify that `fair_up` tracks intuition during trends.
2) Increase `EDGE_MIN` if overtrading.
3) Increase `z_guard` to avoid fading strong trends.
4) Increase `Z_HOLD` to hold only truly “nearly guaranteed” trends.
5) Always validate changes using `explain_fills.py` on the last 100 fills.
