---
name: polymarket-trader
description: Build, evaluate, and tune a Polymarket BTC 1h Up/Down trading strategy using Binance (resolution source) as the anchor. Use when: (1) designing a mispricing/edge model (fair probability vs market price), (2) adding regime filters (trend vs range), (3) debugging bad entries/exits from events.jsonl/state.json, (4) running quick offline analysis or parameter sweeps with the bundled scripts.
---

# Polymarket Trader

Maintain a profitable **BTC 1h Up/Down** strategy by anchoring decisions to **Binance BTCUSDT** (the resolution source) and enforcing anti-churn/risk rules.

## Workflow (use this order)

1) **Confirm the market type**
- This skill is optimized for `bitcoin-up-or-down-*` 1h markets (Binance 1H open vs close).

2) **Compute the anchor signal (Binance)**
- Fetch 1m closes + the 1h open for the relevant hour.
- Compute volatility (sigma) and time-to-expiry.
- Convert to **fair probability** for Up/Down.

3) **Trade only when there is measurable edge**
- Enter only if `edge = fair_prob - market_price` exceeds a threshold.
- Add a directional guardrail: do not bet against the sign of the move when |z| is non-trivial.

4) **Exit using the right logic for the entry mode**
- Model entries: exit on **edge decay / model flip**; hold to preclose when confidence is extreme.
- Mean-reversion entries: exit on **reversion targets** (not model-tp), with strict churn limits.

5) **Validate with logs**
- Every suspected “nonsense trade” must be explained via:
  - `reason` / `entry_mode`
  - Binance-derived fair probability + z
  - whether the correct exit block fired

## Bundled scripts

All scripts are designed to be run from the OpenClaw workspace.

### 1) Fetch Binance klines
- `{baseDir}/scripts/binance_klines.py`
  - Pulls klines and prints JSON.

### 2) Dump/stabilization and regime metrics
- `{baseDir}/scripts/binance_regime.py`
  - Computes ret5/ret15/slope10 + simple “stabilized” boolean.

### 3) Explain fills (events.jsonl) with Binance context
- `{baseDir}/scripts/explain_fills.py`
  - Reads paperbot `events.jsonl` and prints a concise table for the last N fills:
    - side/outcome/px/reason
    - estimated fair_up + z
    - “against trend?” flag

## References

- `{baseDir}/references/strategy.md` — the math model, parameters, and tuning checklist.
