---
name: polymarket-oracle
description: Multi-strategy arbitrage and trading bot for Polymarket prediction markets. Scans ALL markets (crypto, politics, sports, economics, entertainment) for parity arbitrage, logical arbitrage, tail-end trading, market making, and latency opportunities.
version: 1.0.0
metadata:
  openclaw:
    emoji: "🎯"
    requires:
      bins: ["python3"]
      env:
        required:
          - POLYMARKET_API_KEY
          - POLYMARKET_SECRET
          - POLYMARKET_PASSPHRASE
        optional:
          - TELEGRAM_BOT_TOKEN  # For alerts only
          - TELEGRAM_CHAT_ID    # For alerts only
          - WALLET_PRIVATE_KEY  # Only for initial API key creation, not runtime
    network_behavior:
      makes_requests: true
      endpoints_allowed:
        - "https://clob.polymarket.com/*"
        - "https://gamma-api.polymarket.com/*"
        - "wss://ws-subscriptions-clob.polymarket.com/*"
        - "https://api.telegram.org/bot*"
      requires_credentials: true
      uses_websocket: true
    security_level: "L3 - Financial Execution (Real Money)"
    author: "Georges Andronescu (Wesley Armando)"
    license: "MIT"
    homepage: "https://github.com/georges91560/polymarket-oracle"
    repository: "https://github.com/georges91560/polymarket-oracle"
---

# Polymarket Oracle — Multi-Strategy Arbitrage Bot

## 🎯 WHAT IT DOES

**Scans ALL Polymarket markets for profitable opportunities.**

**Markets covered:**
- ✅ **Crypto** (BTC, ETH, altcoins - 5min, 15min, daily markets)
- ✅ **Politics** (Elections, policy, polls, debates)
- ✅ **Sports** (NBA, NFL, MLB, NHL, Soccer, UFC, Tennis, Golf)
- ✅ **Economics** (Fed rates, CPI, jobs, GDP, stock markets)
- ✅ **Technology** (Apple, Tesla, Google, IPOs, launches)
- ✅ **Entertainment** (Oscars, Emmys, box office, celebrities)
- ✅ **Weather** (Hurricanes, temperatures, climate events)
- ✅ **Miscellaneous** (Viral events, trends, binary outcomes)

**Total:** 1000-5000+ markets scanned continuously

---

## 🔥 STRATEGIES DETECTED

### **1. Parity Arbitrage**

**What:** YES + NO prices don't sum to $1.00

```
YES price: $0.45
NO price: $0.52
Total: $0.97

Buy both → Guaranteed payout: $1.00
Profit: $0.03 (3.1%)

Risk: ZERO (guaranteed profit)
```

**Frequency:** 5-20 per day  
**Duration:** 2-15 seconds  
**Win rate:** 100% (if executed)

---

### **2. Logical Arbitrage**

**What:** Impossible price combinations between related markets

```
Market A: "Chiefs win Super Bowl" = 28%
Market B: "AFC team wins" = 24%

Impossible! Chiefs ARE an AFC team!

Buy "AFC wins" at 24%
If Chiefs win (28%) → AFC wins → Profit
If other AFC wins → Profit
Cannot lose unless NFC wins
```

**Frequency:** 2-10 per day  
**Duration:** Minutes to hours  
**Win rate:** 90-95%

---

### **3. Tail-End Trading**

**What:** Buy highly certain outcomes (>95%) just before resolution

```
Event: Fed keeps rates (99% certain)
Market price: $0.97

Buy at $0.97
Resolution: $1.00
Profit: $0.03 (3.1%)

Risk: Very low (event almost certain)
```

**Frequency:** 10-30 per day  
**Duration:** Hours to days  
**Win rate:** 95-98%

---

### **4. Market Making**

**What:** Provide liquidity, earn spread + maker rebates

```
Token midpoint: $0.50

Place orders:
BID: $0.475 (maker)
ASK: $0.525 (maker)

Spread capture: $0.05 (10%)
+ Polymarket rebates
+ Liquidity rewards (3x multiplier)

Monthly: 10-25% annualized
```

**Frequency:** Continuous  
**Duration:** Indefinite  
**Win rate:** 80-90% (inventory risk)

---

### **5. Latency Arbitrage**

**What:** Trade on information before market adjusts

```
Bitcoin 5-min market:
- Monitor Binance/Chainlink feed
- When price crosses threshold
- Bot knows resolution 2-15s before UI

Trade before market reacts
```

**Frequency:** 50-200 per day (crypto markets)  
**Duration:** Seconds  
**Win rate:** 70-85%

---

### **6. Combinatorial Arbitrage (AI-powered)**

**What:** Find mispriced relationships between multiple markets

```
Using sentence embeddings (e5-large-v2)
Find related markets:
- "Trump wins election"
- "Trump wins popular vote"
- "Trump wins by 5%+"

If Trump wins by 5%+ → wins popular vote
But prices show 30% vs 48% = Mispricing
```

**Frequency:** 3-15 per day  
**Duration:** Hours to days  
**Win rate:** 75-90%

---

## 📊 MARKET CATEGORIZATION

**Automatic categorization by keywords:**

```python
Categories = {
    'crypto': Bitcoin, Ethereum, DeFi, altcoins
    'politics': Elections, presidents, votes, polls
    'sports': NBA, NFL, Soccer, UFC, Tennis
    'economics': Fed, CPI, jobs, GDP, stocks
    'technology': Apple, Tesla, Google, IPOs
    'entertainment': Oscars, movies, celebrities
    'weather': Hurricanes, temperatures, climate
    'other': Everything else
}
```

**Strategy application:**
- Crypto → Latency + Market Making
- Politics → Logical + Tail-End
- Sports → Parity + News Arbitrage
- Economics → Tail-End + Market Making
- All → Parity + Combinatorial

---

## ⚡ EXECUTION SPEED

**Parallel Scanning:**
```
Workers: 50 parallel threads
Markets scanned: 1000-2000 per minute
Opportunities detected: Real-time
Execution: <1 second from detection
```

**Scan Cycle:**
```
00s - Fetch all active markets (Gamma API)
05s - Categorize markets automatically
10s - Parallel scan with 50 workers
30s - Detect opportunities across 5 strategies
35s - Alert via Telegram
40s - Wait 20 seconds
60s - REPEAT
```

---

## 💰 CAPITAL ALLOCATION

**Default configuration:**
```
Total capital: $10,000 (configurable)
Max per market: $1,000 (1-10% of capital)

Strategy allocation:
- Parity arb: 20% ($2,000)
- Tail-end: 40% ($4,000)
- Market making: 30% ($3,000)
- Latency: 10% ($1,000)
```

**Position sizing:**
- High certainty (>95%): $500-$5,000
- Medium certainty (90-95%): $200-$2,000
- Speculative (<90%): $100-$1,000

---

## 📱 TELEGRAM ALERTS

**Real-time notifications:**

```
🎯 POLYMARKET OPPORTUNITIES

Found 27 opportunities:

PARITY_ARBITRAGE: 8
TAIL_END: 12
MARKET_MAKING: 5
LATENCY: 2

Top 5 by profit:

• parity_arbitrage: 4.23%
  NBA Lakers vs Warriors - Game Winner...

• tail_end: 3.87%
  Fed Rate Decision - Keeps Rates...

• parity_arbitrage: 3.54%
  Bitcoin Closes Above $45K Today...

• tail_end: 3.12%
  Super Bowl Winner - Chiefs...

• market_making: 2.89%
  Ethereum Above $2500 - 5min...
```

---

## 🛡️ RISK MANAGEMENT

**Built-in protections:**
- Max position per market
- Total capital limits
- Strategy diversification
- Event resolution monitoring
- Inventory risk tracking

**Circuit breakers:**
```
Daily loss > 5% → Pause 1 hour
Total drawdown > 10% → Alert + reduce sizes
API rate limits → Auto-throttle
Failed trades > 10 → Pause strategy
```

---

## 🎯 PERFORMANCE TARGETS

**Conservative (Parity + Tail-End):**
```
Capital: $10,000
Monthly ROI: 8-15%
Monthly profit: $800-$1,500
Trades/day: 10-30
Win rate: 92-98%
```

**Aggressive (All Strategies):**
```
Capital: $50,000
Monthly ROI: 15-30%
Monthly profit: $7,500-$15,000
Trades/day: 50-200
Win rate: 80-90%
```

**Real stats (from research):**
- $40M extracted April 2024 - April 2025
- Top users: $1K-$2.2M profits
- Bot win rates: 70-99%
- Opportunities duration: 2s-48h

---

## 📊 API USAGE

**Gamma API (Market Discovery):**
```
GET /markets - Get all active markets
GET /markets/{id} - Get market details
Rate limit: 60 req/min
```

**CLOB API (Trading):**
```
GET /book?token_id={id} - Order book
GET /midpoint?token_id={id} - Midpoint price
GET /price?token_id={id}&side={BUY/SELL} - Best price
POST /order - Place order
DELETE /order - Cancel order

Rate limit: Public 60/min, Authenticated 100/min
```

**WebSocket (Real-time):**
```
wss://ws-subscriptions-clob.polymarket.com/ws/market/{token_id}
- Order book updates
- Trade updates
- Price changes
```

---

## 🔒 SECURITY & TRANSPARENCY

**What it does:**
- ✅ Scans public Polymarket markets
- ✅ Places orders via CLOB API
- ✅ Uses your Polygon wallet
- ✅ Trades with your USDC
- ✅ Reports via Telegram

**What it requires:**
- ✅ Polymarket API credentials
- ✅ Polygon wallet private key
- ✅ USDC balance on Polygon
- ✅ Telegram bot (alerts)

**Safeguards:**
- ✅ Position size limits
- ✅ Strategy diversification
- ✅ Event resolution monitoring
- ✅ Circuit breakers
- ✅ Full audit trail

**Never:**
- ❌ Trades without detection
- ❌ Exceeds position limits
- ❌ Bypasses risk controls

---

## ⚠️ IMPORTANT NOTES

**Polymarket specifics:**
- Operates on Polygon (low gas fees)
- Trades settle on-chain (USDC)
- Events resolve when outcome known
- Markets can be cancelled/invalid
- Fees: 2% on winners (some markets)

**Capital requirements:**
- Minimum: $1,000 (limited opportunities)
- Recommended: $5,000-$10,000
- Professional: $50,000+

**Legal:**
- Check local regulations
- Prediction markets may be restricted
- Use at your own risk
- Not financial advice

---

**Version:** 1.0.0  
**License:** MIT  
**Author:** Georges Andronescu (Wesley Armando)

**SCAN EVERYTHING. TRADE EVERYTHING. PROFIT EVERYWHERE. 🎯💰**

---

**END OF SKILL**
