---
name: polymarket-latest-events
description: Fetch the latest events from Polymarket prediction market. Use when user asks about Polymarket events, prediction markets, trending bets, or wants to see what's new on Polymarket.
---

# Polymarket Latest Events

Fetch the latest events from the Polymarket prediction market platform.

## When to Use

Use this skill when the user:
- Asks about the latest events or markets on Polymarket
- Wants to see trending prediction markets
- Mentions Polymarket, prediction market, or betting odds
- Asks "what's new on Polymarket" or similar queries

## How to Fetch

Use web_fetch (or curl via Bash) to call the Polymarket Gamma API. No API key or authentication is required.

### Get the 10 latest events

curl -s "https://gamma-api.polymarket.com/events?active=true&closed=false&limit=10&order=createdAt&ascending=false"


Or with web_fetch:

web_fetch url="https://gamma-api.polymarket.com/events?active=true&closed=false&limit=10&order=createdAt&ascending=false"


### Response format

The API returns a JSON array. Each event object contains:

| Field | Description |
|-------|-------------|
| title | Event title / question |
| slug | URL slug for the event |
| description | Detailed description |
| startDate | Event start date |
| createdAt | When the event was created |
| volume | Total trading volume |
| liquidity | Available liquidity |
| markets | Array of sub-markets with outcomes and prices |
| tags | Category tags |

### Build event links

The Polymarket URL for each event is:

https://polymarket.com/event/{slug}


### Read market prices

Each event has a markets array. Each market contains:
- question: The specific question
- outcomes: JSON string like ["Yes", "No"]
- outcomePrices: JSON string like ["0.65", "0.35"] (probabilities)

## Output Format

Present the results as a clean list:

1. {title} — {short description or first tag}
   - Odds: Yes {price}% / No {price}%
   - Link: https://polymarket.com/event/{slug}

## Filtering Options

You can customize the API query:
- By category: add &tag_id={id} (get tag IDs from `https://gamma-api.polymarket.com/tags?limit=100`)
- By volume: &order=volume&ascending=false for most-traded events
- By sport: use https://gamma-api.polymarket.com/sports to discover leagues, then filter by &series_id={id}
- More results: change &limit=10 to any number
