"""
Human-friendly HTML Dashboard
"""

from dashboard import get_dashboard_data

def render_dashboard_html() -> str:
    """Render a nice HTML dashboard."""
    data = get_dashboard_data()
    stats = data["stats"]
    financials = data["financials"]
    
    # Format recent payments
    payments_html = ""
    if data["recent_payments"]:
        for p in data["recent_payments"][:5]:
            payments_html += f'''
            <tr>
                <td><a href="https://basescan.org/tx/{p['hash']}" target="_blank">{p['hash'][:10]}...</a></td>
                <td>{p['from'][:10]}...</td>
                <td>${p['amount']:.2f}</td>
                <td>{p['timestamp'][:16]}</td>
            </tr>'''
    else:
        payments_html = '<tr><td colspan="4" style="text-align:center;color:#666;">No payments yet - be the first! 🚀</td></tr>'
    
    return f'''<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PolyEdge - Dashboard</title>
    <style>
        * {{ margin: 0; padding: 0; box-sizing: border-box; }}
        body {{
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: #eee;
            min-height: 100vh;
            padding: 2rem;
        }}
        .container {{ max-width: 900px; margin: 0 auto; }}
        h1 {{
            font-size: 2rem;
            margin-bottom: 0.5rem;
            background: linear-gradient(90deg, #00d9ff, #00ff88);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }}
        .subtitle {{ color: #888; margin-bottom: 2rem; }}
        .grid {{
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }}
        .card {{
            background: rgba(255,255,255,0.05);
            border-radius: 12px;
            padding: 1.5rem;
            border: 1px solid rgba(255,255,255,0.1);
        }}
        .card-label {{ color: #888; font-size: 0.85rem; margin-bottom: 0.5rem; }}
        .card-value {{ font-size: 1.8rem; font-weight: bold; }}
        .card-value.green {{ color: #00ff88; }}
        .card-value.blue {{ color: #00d9ff; }}
        .card-value.yellow {{ color: #ffd700; }}
        .section {{ margin-bottom: 2rem; }}
        .section h2 {{
            font-size: 1.2rem;
            margin-bottom: 1rem;
            color: #00d9ff;
        }}
        table {{
            width: 100%;
            border-collapse: collapse;
            background: rgba(255,255,255,0.03);
            border-radius: 8px;
            overflow: hidden;
        }}
        th, td {{
            padding: 0.75rem 1rem;
            text-align: left;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }}
        th {{ background: rgba(255,255,255,0.05); color: #888; font-weight: 500; }}
        a {{ color: #00d9ff; text-decoration: none; }}
        a:hover {{ text-decoration: underline; }}
        .links {{
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }}
        .link-btn {{
            background: rgba(0,217,255,0.1);
            border: 1px solid #00d9ff;
            color: #00d9ff;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            text-decoration: none;
            font-size: 0.9rem;
        }}
        .link-btn:hover {{
            background: rgba(0,217,255,0.2);
            text-decoration: none;
        }}
        .wallet {{
            font-family: monospace;
            background: rgba(0,0,0,0.3);
            padding: 0.75rem 1rem;
            border-radius: 6px;
            font-size: 0.9rem;
            word-break: break-all;
        }}
        .footer {{
            margin-top: 3rem;
            padding-top: 1.5rem;
            border-top: 1px solid rgba(255,255,255,0.1);
            color: #666;
            font-size: 0.85rem;
            text-align: center;
        }}
        .emoji {{ font-size: 1.5rem; margin-right: 0.5rem; }}
    </style>
</head>
<body>
    <div class="container">
        <h1>⚡ PolyEdge</h1>
        <p class="subtitle">x402 Paid API • Base L2 • $0.05/request</p>
        
        <div class="grid">
            <div class="card">
                <div class="card-label">💰 Balance</div>
                <div class="card-value green">{financials['current_balance']}</div>
            </div>
            <div class="card">
                <div class="card-label">📊 Total Requests</div>
                <div class="card-value blue">{stats['total_requests']}</div>
            </div>
            <div class="card">
                <div class="card-label">✅ Paid Requests</div>
                <div class="card-value green">{stats['paid_requests']}</div>
            </div>
            <div class="card">
                <div class="card-label">🔄 Conversion</div>
                <div class="card-value yellow">{stats['conversion_rate']}</div>
            </div>
        </div>
        
        <div class="section">
            <h2>📈 Session Revenue</h2>
            <div class="card">
                <div class="card-value green">{financials['estimated_session_revenue']}</div>
                <div class="card-label" style="margin-top:0.5rem;">Since container restart • {stats['uptime_hours']}h uptime</div>
            </div>
        </div>
        
        <div class="section">
            <h2>💸 Recent Payments</h2>
            <table>
                <thead>
                    <tr>
                        <th>Transaction</th>
                        <th>From</th>
                        <th>Amount</th>
                        <th>Time</th>
                    </tr>
                </thead>
                <tbody>
                    {payments_html}
                </tbody>
            </table>
        </div>
        
        <div class="section">
            <h2>🔗 Quick Links</h2>
            <div class="links">
                <a href="/" class="link-btn">📖 API Docs</a>
                <a href="/health" class="link-btn">💚 Health Check</a>
                <a href="/api/v1/dashboard" class="link-btn">🤖 JSON Dashboard</a>
                <a href="{data['links']['explorer']}" target="_blank" class="link-btn">🔍 Block Explorer</a>
            </div>
        </div>
        
        <div class="section">
            <h2>💳 Payment Wallet</h2>
            <div class="wallet">{data['wallet']}</div>
            <p style="margin-top:0.5rem;color:#666;font-size:0.85rem;">Network: Base L2 • Asset: USDC</p>
        </div>
        
        <div class="footer">
            Built by Gibson 🤖 • Powered by x402 Protocol
        </div>
    </div>
</body>
</html>'''
