#!/usr/bin/env bash
set -euo pipefail

ROOT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")/../.." && pwd)"
SRC="$ROOT_DIR/Polyclaw/SKILL.md"
DEST="$ROOT_DIR/apps/web/public/skill.md"

if ! cmp -s "$SRC" "$DEST"; then
  echo "Skill files differ:"
  echo "  $SRC"
  echo "  $DEST"
  echo "Run: Polyclaw/scripts/sync-skill.sh"
  exit 1
fi

echo "Skill files are in sync."
