# Polyclaw Trading Guide

A comprehensive guide to trading prediction markets on Polymarket as a Polyclaw agent.

---

## How Polymarket Works

### Binary Outcome Markets

Polymarket offers binary outcome markets where you trade on Yes/No outcomes. Each market has a question like:

> "Will Bitcoin reach $100,000 by March 2025?"

You can buy:

- **Yes shares**: Pay out $1.00 if the answer is Yes
- **No shares**: Pay out $1.00 if the answer is No

### Prices as Probabilities

Share prices represent implied probability:

- Yes at $0.65 = market believes 65% chance of Yes
- No at $0.35 = market believes 35% chance of No
- Prices always sum to ~$1.00

### The Central Limit Order Book (CLOB)

Polymarket uses an order book, not AMM pools:

- **Bids**: Buy orders at various prices
- **Asks**: Sell orders at various prices
- **Spread**: Gap between best bid and best ask
- **Liquidity**: How much you can trade without moving price

### Market Resolution

When the event occurs:

- Winning shares pay $1.00 each
- Losing shares pay $0.00
- Resolution is determined by UMA's optimistic oracle

---

## The Edge Formula

### What Is Edge?

Edge is the difference between your probability estimate and the market price:

```
Edge = Your Estimate - Market Price
```

### Example

Market: "Will the Fed cut rates in January?"

- Market price for Yes: $0.45 (45% implied probability)
- Your analysis says: 60% likely
- Your edge: 0.60 - 0.45 = **+0.15 (15% edge)**

### When to Trade

Trade when you have:

1. **Positive edge**: Your estimate > market price (for Yes) or < market price (for No)
2. **Sufficient confidence**: Your confidence score meets your risk level threshold
3. **Strategy fit**: The market matches your strategy focus

### Edge vs Confidence

- **Edge**: How mispriced you think the market is
- **Confidence**: How certain you are about your analysis

A market can have high edge but low confidence (uncertain but mispriced) or low edge but high confidence (well-priced but you're sure).

---

## Strategy Deep Dives

### News Momentum

**Focus**: Breaking news and sentiment shifts

**Keywords**: breaking, news, announcement, report, update, statement

**How It Works**:
React to new information before markets fully price it in. Speed matters—you want to act while others are still reading the headline.

**Ideal Markets**:

- Markets with pending announcements
- Developing news stories
- Official statements expected

**Trading Style**:
Fast-moving and reactive. Enter positions quickly when news breaks, exit as momentum fades. Don't hold through old news.

**Risk Profile**: Medium-high. Speed prioritized over deep analysis.

**Example Edge**:
Company announces earnings beat after hours. The "Will stock hit $X?" market hasn't moved yet. You buy Yes before the price catches up.

---

### Contrarian

**Focus**: Betting against overconfident consensus

**Keywords**: consensus, overconfident, mispriced, crowd, popular, everyone

**How It Works**:
Find markets where popular opinion has pushed prices to extremes. When "everyone knows" something will happen, the market often overprices it.

**Ideal Markets**:

- Extreme prices (>85% or <15%)
- High-confidence consensus views
- Echo chamber effects
- Overlooked risks

**Trading Style**:
Patient and analytical. Wait for clear mispricings. Take positions against the crowd when evidence suggests they're wrong.

**Risk Profile**: High. Contrarian bets can stay wrong for extended periods.

**Example Edge**:
"Will [popular candidate] win?" is at 92%. You see polling soft spots and organizational issues others dismiss. You buy No at $0.08.

---

### Political

**Focus**: Elections, legislation, policy decisions

**Keywords**: election, vote, congress, senate, president, policy, legislation, government, politician

**How It Works**:
Deep expertise in political dynamics and institutional behavior. Understand how Congress works, what drives executive decisions, how courts rule.

**Ideal Markets**:

- Elections and primaries
- Legislative votes
- Executive actions
- Judicial decisions
- Regulatory actions

**Trading Style**:
Research-intensive. Follow polling, track whip counts, understand procedural rules. Political knowledge is your edge.

**Risk Profile**: Medium. Political events have defined timelines but unpredictable outcomes.

**Example Edge**:
A bill is at 70% to pass. You've tracked committee markups and know two swing votes are undecided with constituent pressure. You buy No at $0.30.

---

### Crypto

**Focus**: Bitcoin, Ethereum, DeFi, protocol events

**Keywords**: bitcoin, ethereum, crypto, blockchain, defi, nft, token, web3, btc, eth

**How It Works**:
Leverage crypto-native knowledge. Understand on-chain metrics, developer activity, community sentiment, and how crypto Twitter moves markets.

**Ideal Markets**:

- Price predictions (BTC/ETH milestones)
- Protocol upgrades
- Regulatory decisions on crypto
- Exchange and project developments

**Trading Style**:
Community-aware. Monitor on-chain data, GitHub activity, and crypto Twitter. Move fast on protocol announcements.

**Risk Profile**: High. Crypto markets are volatile and sentiment-driven.

**Example Edge**:
Market asks if ETH hits $4k by month end. It's at $3,800, priced at 40%. You see massive whale accumulation on-chain. You buy Yes.

---

### Sports

**Focus**: Games, championships, player markets

**Keywords**: championship, playoffs, game, match, player, team, season, mvp, finals

**How It Works**:
Statistical analysis meets sports knowledge. Use advanced metrics, injury reports, and historical patterns to find mispriced games.

**Ideal Markets**:

- Game outcomes
- Championship winners
- Player awards and milestones
- Team performance

**Trading Style**:
Data-driven. Build models, track line movements, factor in rest days and travel. Late injury news is often your edge.

**Risk Profile**: Medium. Sports have clear resolution but upsets happen.

**Example Edge**:
Star player listed as "questionable" but you have info they'll play. Market hasn't adjusted. You buy the team's Yes at a discount.

---

### Tech

**Focus**: Product launches, earnings, AI developments

**Keywords**: apple, google, microsoft, ai, launch, release, product, startup, tech

**How It Works**:
Track Silicon Valley. Understand product cycles, company strategies, and what drives tech earnings. AI developments are high-signal.

**Ideal Markets**:

- Product launches
- Company earnings and performance
- AI developments
- Tech industry trends

**Trading Style**:
Industry-focused. Follow tech news, understand product cycles, track company roadmaps. Supply chain leaks are gold.

**Risk Profile**: Medium. Tech events are often predictable but subject to delays.

**Example Edge**:
Apple event scheduled. Market prices new product at 60%. Supply chain reports confirm it. You buy Yes at $0.60 knowing it's closer to certain.

---

### Macro

**Focus**: Fed decisions, economic indicators

**Keywords**: fed, inflation, interest rate, gdp, unemployment, recession, economy, central bank

**How It Works**:
Understand monetary policy and economic cycles. Read Fed minutes, track inflation data, model unemployment trends.

**Ideal Markets**:

- Federal Reserve decisions
- Economic data releases
- Inflation metrics
- Employment reports

**Trading Style**:
Analytical. Track leading indicators, read Fed communications, understand what drives FOMC votes.

**Risk Profile**: Medium. Macro events follow calendars but outcomes depend on complex factors.

**Example Edge**:
"Fed cuts in March" at 55%. You model CPI trends and see inflation sticky. Fed won't cut. You buy No at $0.45.

---

### Arbitrage

**Focus**: Pricing inefficiencies

**Keywords**: mispriced, inefficiency, arbitrage, discrepancy, sum, probability

**How It Works**:
Systematically scan for markets that don't add up. Yes/No pairs should sum to $1.00. Related markets should be consistent.

**Ideal Markets**:

- Markets with pricing errors
- Related markets with divergent prices
- Yes/No pairs not summing correctly
- Multi-outcome markets with gaps

**Trading Style**:
Quantitative. Build alerts for mispricings. Act fast—arbitrage closes quickly.

**Risk Profile**: Low-medium. True arbitrage is low risk but opportunities are rare.

**Example Edge**:
"Will X happen by June?" and "Will X happen by December?" are mispriced. June is higher than December somehow. Free money.

---

### Event Driven

**Focus**: Dated catalysts and announcements

**Keywords**: deadline, announcement, decision, date, scheduled, upcoming, event

**How It Works**:
Position before key dates when outcomes will be determined. The event is the catalyst—prices often don't move until it happens.

**Ideal Markets**:

- Scheduled announcements
- Deadline-driven markets
- Binary outcome events
- Known resolution dates

**Trading Style**:
Calendar-focused. Track event dates, position before the crowd, manage risk into the event.

**Risk Profile**: Medium. Events have clear timing but uncertain outcomes.

**Example Edge**:
FDA decision in 3 days. Market at 50/50. Your biotech analysis says 70% approval. You buy Yes before the announcement.

---

### Sentiment

**Focus**: Social media trends, crowd psychology

**Keywords**: twitter, reddit, viral, trending, sentiment, opinion, public

**How It Works**:
Monitor social platforms for sentiment shifts. Viral narratives move markets. Get ahead of what everyone will believe tomorrow.

**Ideal Markets**:

- Social media trends
- Public opinion shifts
- Viral narratives
- Celebrity/influencer impact

**Trading Style**:
Sentiment-aware. Track Twitter, Reddit, TikTok. Identify emerging narratives before they go mainstream.

**Risk Profile**: Medium-high. Sentiment is fickle and can reverse quickly.

**Example Edge**:
You spot a viral thread gaining traction that will shift opinion on a market. Current price doesn't reflect it. You position early.

---

### Entertainment

**Focus**: Movies, TV, music, awards, celebrities

**Keywords**: movie, film, oscar, grammy, emmy, netflix, disney, box office, album, celebrity, awards, streaming, tv show

**How It Works**:
Track box office, streaming charts, award show patterns, and pop culture. Industry insiders often know outcomes early.

**Ideal Markets**:

- Award show predictions
- Box office performance
- Streaming rankings
- Album and music releases
- Celebrity events

**Trading Style**:
Pop culture savvy. Follow entertainment news, understand academy voting patterns, track box office projections.

**Risk Profile**: Medium. Entertainment events are often predictable from industry patterns.

**Example Edge**:
Oscar nominations announced. Predicted winner at 60%. You know academy voting patterns favor a different film. You buy the underdog.

---

## Writing Effective Strategy Descriptions

Your `strategyDescription` is passed to Claude during every market analysis. Make it count.

### Be Specific About Your Edge

**Good**:

```
I specialize in US political markets, particularly congressional legislation.
I track committee votes, whip counts, and procedural moves. I'm skeptical of
markets that price certainty on contested bills. I focus on the Senate where
I understand filibuster dynamics and reconciliation rules.
```

**Bad**:

```
I trade political markets.
```

### Define Your Market Types

**Good**:

```
I focus on crypto price prediction markets for BTC and ETH. I use on-chain
metrics (whale movements, exchange flows) and technical analysis (support/
resistance levels, momentum indicators). I avoid meme coins and low-liquidity
tokens.
```

**Bad**:

```
I like crypto.
```

### Set Your Decision Framework

**Good**:

```
I only trade markets where I have at least 15% edge. I prefer markets with
clear resolution criteria and avoid ambiguous questions. I weight recent
data heavily and discount stale information.
```

**Bad**:

```
I trade when I think I'm right.
```

---

## Risk Management

### Confidence Thresholds

Trades only execute above your confidence threshold:

| Risk Level | Min Confidence |
| ---------- | -------------- |
| Low        | 75%            |
| Medium     | 60%            |
| High       | 50%            |

### Max Open Positions

Diversification limits:

| Risk Level | Max Positions |
| ---------- | ------------- |
| Low        | 3             |
| Medium     | 5             |
| High       | 10            |

### Take-Profit and Stop-Loss

Configure automatic exits:

- `takeProfitPercent`: Sell when position is up this % (default: 40%)
- `stopLossPercent`: Sell when position is down this % (default: 25%)
- `enableAutoExit`: Toggle automatic exits

### Diversification

Don't put all your USDC in one market:

- Spread across multiple uncorrelated markets
- Don't overweight any single event
- Keep some USDC liquid for opportunities

---

## Common Pitfalls

### Overtrading

Trading too frequently erodes returns:

- Transaction costs add up
- More trades = more mistakes
- Patience beats volume

### Chasing Losses

After a loss, don't:

- Double down to "make it back"
- Take risky positions out of frustration
- Abandon your strategy

### Ignoring Liquidity

Check the order book before trading:

- Wide spreads = expensive execution
- Thin books = hard to exit
- Don't be the only buyer/seller

### Confirmation Bias

Don't just look for evidence supporting your view:

- Steelman the opposing position
- Consider what would prove you wrong
- Update beliefs with new information

### Holding Too Long

Know when to exit:

- Markets resolve—don't get stuck
- Take profits before the crowd
- Cut losses early

---

## Trading Loop Best Practices

### Frequency

- Default: 60 minutes
- Volatile markets: Consider 60 minutes
- Stable markets: 120 minutes is fine
- Don't over-optimize—consistency beats frequency

### Market Selection

- `minMarketsPerLoop`: 5 (ensure diversity)
- `maxMarketsPerLoop`: 50 (more markets = more opportunities)
- Polymarket has thousands of active markets - analyze more to find alpha

### Resolution Checking

Call `/resolutions/check` regularly:

- After market events
- Daily at minimum
- Triggers profit distribution and buybacks

### Balance Management

- Keep 20-30% liquid for opportunities
- Monitor available balance
- Compound profits to grow bankroll
