# 中国历史政治斗争参考资料

---

## 一、先秦时期

### 骊山之变与犬戎灭西周（西周 · 前771年）

**背景**：周幽王宠爱褒姒，废申后及太子宜臼，改立褒姒之子伯服为太子。

**主要人物**：周幽王、褒姒、太子宜臼、申侯、犬戎

**经过概要**：申侯联合缯国与犬戎攻入镐京，周幽王在骊山下被杀。太子宜臼在申侯等诸侯拥立下即位，是为周平王，东迁洛邑，西周灭亡。

**结果与影响**：周王室从此衰微，诸侯势力崛起，开启春秋争霸时代。王权式微成为此后数百年政治格局的底色。

---

### 三家分晋（春秋末 · 前453年—前403年）

**背景**：春秋后期晋国公室衰落，卿大夫势力膨胀，韩、赵、魏、智、范、中行六卿长期争斗。

**主要人物**：智伯瑶、赵襄子、韩康子、魏桓子

**经过概要**：智伯势大，胁迫韩、魏向赵氏进攻。赵襄子据守晋阳，后秘密联络韩、魏反戈，于晋阳之战中灭智伯。三家瓜分智氏领地，前403年被周威烈王正式册封为诸侯。

**结果与影响**：三家分晋标志着春秋时代结束、战国时代开始。卿大夫取代公室的模式成为此后政治变革的典型路径。

---

### 田氏代齐（春秋末至战国初 · 前481年—前386年）

**背景**：齐国田氏（陈氏）自田完入齐后，世代经营，通过大斗出小斗入等手段收买民心，势力逐渐超过姜姓公室。

**主要人物**：田成子（田常）、齐简公、田和、周安王

**经过概要**：田常杀齐简公，立齐平公，自此田氏专齐国之政。经数代经营，前386年田和被周安王正式列为诸侯，姜齐灭亡。

**结果与影响**：这是中国历史上第一次完整的"和平演变"式政权更迭，为后世权臣篡位提供了范例。

---

### 商鞅变法与旧贵族反扑（秦 · 前356年—前338年）

**背景**：秦孝公即位，秦国积弱，孝公下求贤令，商鞅自魏入秦。

**主要人物**：秦孝公、商鞅、公子虔、甘龙、杜挚

**经过概要**：商鞅两次变法，废井田、开阡陌、推行县制、奖励耕战、实施连坐。变法触动旧贵族利益，太子师傅公子虔等受刑。秦孝公死后，秦惠文王即位，旧贵族反扑，商鞅被车裂。

**结果与影响**：商鞅虽死，秦法未废。变法奠定了秦国统一六国的制度基础，但也揭示了改革者与既得利益集团斗争的残酷性。

---

## 二、秦朝

### 沙丘之变（秦 · 前210年）

**背景**：秦始皇东巡途中病重，遗诏令长子扶苏继位。

**主要人物**：秦始皇、赵高、李斯、胡亥、扶苏、蒙恬

**经过概要**：始皇驾崩于沙丘平台。中车府令赵高说服丞相李斯篡改遗诏，赐死扶苏与蒙恬，改立少子胡亥为帝（秦二世）。赵高由此掌控朝政。

**结果与影响**：秦二世昏庸无能，赵高指鹿为马、排除异己。暴政激化矛盾，陈胜吴广起义爆发，秦朝二世而亡。

---

### 赵高专权与指鹿为马（秦 · 前210年—前207年）

**背景**：沙丘之变后，赵高以郎中令、丞相之位逐步架空秦二世。

**主要人物**：赵高、秦二世胡亥、李斯、子婴

**经过概要**：赵高先设计陷害李斯使其腰斩族灭，又以"指鹿为马"试探群臣忠诚度，清除异己。最终逼杀秦二世，欲自立未果，改立子婴。子婴即位后设计诛杀赵高。

**结果与影响**：赵高专权是秦朝速亡的重要原因之一，成为宦官（或近臣）乱政的典型案例。

---

## 三、西汉

### 吕后称制（西汉 · 前195年—前180年）

**背景**：汉高祖刘邦死后，惠帝年少懦弱，太后吕雉临朝称制。

**主要人物**：吕雉、惠帝刘盈、吕产、吕禄、周勃、陈平

**经过概要**：吕后大封吕氏子弟为王为侯，违背刘邦"非刘氏不王"的白马之盟。残害戚夫人母子，毒杀赵王刘如意。惠帝死后，吕后更直接控制朝政。前180年吕后病死。

**结果与影响**：吕后死后，太尉周勃、丞相陈平联合刘氏宗室发动政变，诛灭吕氏，迎立代王刘恒（汉文帝），开启文景之治。此事件为后世外戚干政的开端性案例。

---

### 七国之乱（西汉 · 前154年）

**背景**：汉景帝采纳晁错"削藩策"，削减诸侯王封地。

**主要人物**：汉景帝、晁错、吴王刘濞、楚王刘戊、周亚夫

**经过概要**：吴王刘濞联合楚、赵、胶东、胶西、济南、淄川六国，打着"清君侧、诛晁错"的旗号起兵。景帝先腰斩晁错以求和，叛军不退。太尉周亚夫率军出击，三个月内平定叛乱。

**结果与影响**：中央权威得到巩固，诸侯王权力被大幅削弱。为汉武帝推行"推恩令"进一步削藩奠定基础。

---

### 巫蛊之祸（西汉 · 前91年）

**背景**：汉武帝晚年多疑，宠臣江充与太子刘据有隙。

**主要人物**：汉武帝、太子刘据、卫皇后、江充、苏文

**经过概要**：江充借"巫蛊"案诬陷太子在宫中埋藏木偶人诅咒皇帝。太子被迫起兵自卫，与丞相刘屈氂军队激战于长安城中，兵败后自杀。卫皇后亦自杀。

**结果与影响**：武帝晚年追悔，建"思子台"。此案牵连数万人死亡，暴露了皇权专制下太子地位的脆弱性和酷吏政治的危害。

---

### 霍光专权与废立天子（西汉 · 前87年—前68年）

**背景**：汉武帝临终托孤，以大将军霍光为首辅大臣。

**主要人物**：霍光、汉昭帝、昌邑王刘贺、汉宣帝、上官桀

**经过概要**：霍光先挫败上官桀等人的政变阴谋。昭帝死后，迎立昌邑王刘贺，27天后以荒淫无道为由将其废黜（史称"行昌邑王事"），改立刘病已（汉宣帝）。霍光家族权倾朝野。

**结果与影响**：霍光死后，宣帝铲除霍氏家族。霍光废立天子开创了权臣决定皇帝人选的先例，对后世影响深远。

---

### 王莽篡汉（西汉末 · 8年）

**背景**：西汉末年外戚王氏家族势大，王莽以谦恭下士著称，逐步掌握大权。

**主要人物**：王莽、汉平帝、孺子婴、刘歆

**经过概要**：王莽先后任大司马，被封安汉公、假皇帝。利用儒家"禅让"理论和谶纬迷信，制造舆论。8年正式废孺子婴，建立新朝，改国号为"新"。

**结果与影响**：王莽推行的托古改制失败，引发绿林赤眉起义，新朝仅存15年。此为外戚篡位的典型案例，"王莽谦恭未篡时"成为千古名句。

---

## 四、东汉

### 外戚宦官交替专权（东汉 · 25年—189年）

**背景**：东汉自和帝起，皇帝多幼年即位，形成外戚-宦官交替专权的循环。

**主要人物**：窦宪、邓太后、梁冀、窦武、陈蕃、曹节、张让

**经过概要**：幼帝即位→太后临朝→外戚掌权→皇帝长大后借宦官夺权→宦官掌权→下一代幼帝即位→循环往复。梁冀专权20余年，跋扈将军毒杀皇帝；宦官曹节等发动政变杀外戚窦武。这种循环贯穿东汉中后期。

**结果与影响**：外戚宦官反复争斗严重消耗了东汉国力，削弱了士人阶层参政的空间，是东汉衰亡的重要结构性原因。

---

### 党锢之祸（东汉 · 166年、169年）

**背景**：东汉中后期宦官专权，士大夫群体以"清议"方式批评时政、品评人物。

**主要人物**：李膺、陈蕃、范滂、宦官侯览、曹节

**经过概要**：第一次党锢（166年）：太学生与士大夫结党抨击宦官，宦官反诬士人"党人"，桓帝下令禁锢200余人。第二次党锢（169年）：灵帝时，宦官再次发难，陈蕃、窦武被杀，百余名士人被处死，六七百人遭禁锢。

**结果与影响**：大量正直士人被迫害，士大夫阶层元气大伤。东汉政治更加腐败，间接推动了黄巾起义和汉末群雄割据。

---

## 五、三国时期

### 曹操挟天子以令诸侯（东汉末 · 196年—220年）

**背景**：董卓之乱后汉献帝流离失所，曹操迎献帝都许昌。

**主要人物**：曹操、汉献帝、荀彧、董承

**经过概要**：曹操利用"奉天子以令不臣"的政治优势，以朝廷名义征伐四方。衣带诏事件中董承等密谋诛曹被杀。曹操逐步加封魏公、魏王，建立了实际上的曹氏政权。

**结果与影响**：曹操终身未称帝，其子曹丕于220年逼汉献帝禅让，建立魏国。"挟天子以令诸侯"成为后世权臣操控傀儡政权的经典模式。

---

### 高平陵之变（曹魏 · 249年）

**背景**：魏明帝死后，幼帝曹芳即位，大将军曹爽与太傅司马懿共同辅政。曹爽逐步排挤司马懿。

**主要人物**：司马懿、曹爽、桓范、蒋济

**经过概要**：司马懿装病多年麻痹曹爽。趁曹爽随幼帝前往高平陵祭扫之机，司马懿发动政变，控制洛阳城，关闭城门，占据武库。桓范劝曹爽挟天子抵抗，曹爽犹豫不决，最终投降。后曹爽被灭三族。

**结果与影响**：司马氏从此掌控曹魏政权。此后司马师、司马昭继续把持朝政，最终司马炎代魏建晋。高平陵之变是魏晋嬗代的转折点。

---

## 六、两晋

### 八王之乱（西晋 · 291年—306年）

**背景**：晋武帝大封同姓诸王且授予实权，惠帝司马衷智力低下，皇后贾南风干政。

**主要人物**：贾南风、汝南王司马亮、楚王司马玮、赵王司马伦、成都王司马颖等八王

**经过概要**：贾南风先借楚王司马玮之手杀杨骏和汝南王，再杀楚王。后贾南风废杀太子，赵王司马伦发动政变杀贾南风。此后各宗室王争相入朝执政，相互攻伐长达16年。

**结果与影响**：西晋国力大损，北方人口锐减，为五胡乱华创造了条件，晋室南渡。这是宗室分封制度导致内乱的惨痛教训。

---

### 东晋门阀政治（东晋 · 317年—420年）

**背景**：西晋灭亡后，琅琊王司马睿依靠世家大族（特别是王导、王敦家族）在江南建立东晋。

**主要人物**：司马睿、王导、王敦、桓温、谢安、刘裕

**经过概要**："王与马共天下"——王氏家族与皇室共治。王敦两次起兵叛乱。此后桓氏、谢氏等门阀轮流执政。桓温废立天子，谢安淝水之战后北府兵成为新的权力核心，最终刘裕以军功代晋建宋。

**结果与影响**：东晋成为中国历史上门阀政治最典型的时期。皇权受到世族的严重制约，这种权力结构直到隋唐科举制确立后才根本改变。

---

## 七、南北朝

### 刘宋宗室自相残杀（南朝宋 · 420年—479年）

**背景**：刘裕代晋建宋，鉴于东晋宗室无力的教训，分封诸子镇守各方。

**主要人物**：宋文帝刘义隆、太子刘劭、宋孝武帝刘骏、宋明帝刘彧、刘子业

**经过概要**：宋文帝被太子刘劭弑杀，刘骏起兵讨灭刘劭。此后宋孝武帝、前废帝刘子业、宋明帝等连续发生宗室内斗和屠杀，宗室成员几乎被杀尽。

**结果与影响**：刘宋宗室内耗严重削弱了政权根基，最终为萧道成所取代（建立南齐）。成为宗室分封利弊的反面教材。

---

### 北魏孝文帝汉化与六镇起义（北朝 · 471年—534年）

**背景**：北魏孝文帝推行全面汉化改革，迁都洛阳，鲜卑贵族内部产生严重分裂。

**主要人物**：孝文帝拓跋宏、元恂（太子）、尔朱荣、胡太后

**经过概要**：孝文帝强推汉化遭鲜卑保守派抵制，太子元恂谋反被废杀。孝文帝死后，六镇军人（边防鲜卑军事集团）因地位下降而大规模起义。尔朱荣发动河阴之变，杀胡太后及朝臣两千余人。

**结果与影响**：北魏分裂为东魏和西魏。六镇起义催生了北齐和北周两个政权，也孕育了后来统一天下的隋唐政治集团。

---

## 八、隋朝

### 杨广夺嫡（隋 · 600年）

**背景**：隋文帝杨坚原立长子杨勇为太子，杨广为晋王。

**主要人物**：隋文帝杨坚、独孤皇后、杨广（晋王）、杨勇（太子）、杨素

**经过概要**：杨广伪装简朴孝顺，争取母亲独孤皇后支持，同时结交权臣杨素。杨素等不断进谗言攻击杨勇奢侈好色。600年，文帝废杨勇，改立杨广为太子。604年文帝病重，杨广涉嫌弑父篡位。

**结果与影响**：杨广即位后大兴土木、三征高丽，导致民怨沸腾、天下大乱。隋朝二世而亡，与秦朝如出一辙。

---

## 九、唐朝

### 玄武门之变（唐 · 626年）

**背景**：李渊建唐后，太子李建成与秦王李世民因军功和权力分配矛盾激化。

**主要人物**：李世民、李建成、李元吉、尉迟恭、长孙无忌、李渊

**经过概要**：武德九年六月初四，李世民率长孙无忌、尉迟恭等在玄武门设伏。李建成和李元吉入宫时遭到伏击，李世民亲手射杀李建成，尉迟恭杀死李元吉。尉迟恭随后全副武装入宫"护驾"，李渊被迫册立李世民为太子，不久禅位。

**结果与影响**：李世民登基后开创贞观之治。但弑兄逼父的方式深刻影响了唐代皇位继承，此后唐代宫廷政变频繁发生。

---

### 武周革命（唐 · 690年）

**背景**：武则天从唐太宗才人成为高宗皇后，逐步掌握朝政大权。

**主要人物**：武则天、唐高宗李治、长孙无忌、褚遂良、来俊臣、狄仁杰

**经过概要**：武则天先后排除长孙无忌、褚遂良等顾命大臣，以高宗多病为由临朝称制。高宗死后，先后废中宗、睿宗，690年改唐为周，自称圣神皇帝。任用酷吏来俊臣等打击李唐宗室和反对派。晚年任用狄仁杰等贤臣。

**结果与影响**：705年神龙政变，武则天被迫还政李唐。武则天是中国历史上唯一的女皇帝，她的统治打破了门第观念，提拔了大批寒门庶族。

---

### 安史之乱（唐 · 755年—763年）

**背景**：唐玄宗后期沉迷享乐，重用李林甫、杨国忠，对藩镇节度使缺乏节制。

**主要人物**：安禄山、史思明、唐玄宗、杨贵妃、杨国忠、郭子仪、李光弼

**经过概要**：身兼三镇节度使的安禄山以讨伐杨国忠为名起兵叛乱。叛军攻陷洛阳、长安，唐玄宗逃往蜀地，马嵬驿兵变中杨贵妃被赐死。肃宗即位后依靠回纥兵力和郭子仪等将领，经八年苦战平定叛乱。

**结果与影响**：唐朝由盛转衰的转折点。此后藩镇割据、宦官专权、朋党之争三大痼疾困扰唐朝直至灭亡。

---

### 甘露之变（唐 · 835年）

**背景**：唐文宗不甘为宦官操纵的傀儡，密谋铲除宦官势力。

**主要人物**：唐文宗、李训、郑注、仇士良（宦官）

**经过概要**：李训、郑注谋划以"甘露降临"为诱饵，将宦官头目骗入后院诛杀。但计划泄露，宦官仇士良率神策军反击，大肆屠杀朝臣。李训被杀，宰相、朝官死伤千余人。

**结果与影响**：文宗从此成为彻底的傀儡，感叹"受制于家奴"。宦官权势更盛，直到唐末朱温彻底诛灭宦官集团。甘露之变是唐代宦官专权的标志性事件。

---

### 牛李党争（唐 · 808年—846年）

**背景**：唐代中后期，以牛僧孺为首的科举出身官员与以李德裕为首的门荫贵族官员之间长期对立。

**主要人物**：牛僧孺、李宗闵（牛党）；李德裕（李党）

**经过概要**：两派在用人路线、对藩镇政策、对外策略等方面尖锐对立。随着皇帝和宦官的态度变化，两派轮流执政，互相倾轧近四十年。

**结果与影响**：朋党之争严重消耗了唐朝的政治资源，使朝廷无力应对藩镇割据和宦官专权等根本问题。牛李党争与藩镇、宦官并称晚唐三大政治毒瘤。

---

## 十、五代十国

### 后梁篡唐与五代更迭（五代 · 907年—960年）

**背景**：唐末藩镇割据，朱温（朱全忠）消灭宦官集团后掌控朝廷。

**主要人物**：朱温、李存勖、石敬瑭、刘知远、郭威、柴荣

**经过概要**：朱温篡唐建后梁，此后五十余年间政权频繁更迭：后梁→后唐→后晋→后汉→后周。石敬瑭割让燕云十六州换取契丹支持，留下巨大隐患。

**结果与影响**：武人专政、兵变夺权成为常态。赵匡胤正是在这一背景下发动陈桥兵变，建立北宋并着力解决武人乱政的问题。

---

## 十一、北宋

### 陈桥兵变（北宋 · 960年）

**背景**：后周世宗柴荣死后，幼帝柴宗训即位，主少国疑。

**主要人物**：赵匡胤、赵普、石守信、赵光义

**经过概要**：殿前都点检赵匡胤率军北上抗辽，行至陈桥驿，部下"黄袍加身"拥立赵匡胤为帝。赵匡胤回师开封，后周恭帝禅让，北宋建立。

**结果与影响**：赵匡胤吸取五代教训，通过"杯酒释兵权"解除武将兵权，建立以文制武的政治体制，结束了五代以来武人乱政的局面。

---

### 王安石变法与新旧党争（北宋 · 1069年—1085年及其后）

**背景**：北宋中期财政困难、军事积弱，宋神宗支持王安石推行改革。

**主要人物**：宋神宗、王安石（新党）；司马光、欧阳修、苏轼（旧党）

**经过概要**：王安石推行青苗法、免役法、保甲法、市易法等新法，旨在富国强兵。以司马光为首的旧党激烈反对。神宗死后，高太后临朝，司马光尽废新法。此后哲宗亲政恢复新法，新旧两党反复执政，互相打击。

**结果与影响**：新旧党争演变为意气之争，改革本意被遗忘。北宋政治内耗严重，国力不升反降。这场党争延续至北宋灭亡，为靖康之变埋下伏笔。

---

### 靖康之变（北宋 · 1127年）

**背景**：金灭辽后南下攻宋，宋徽宗的昏庸统治使北宋无力抵抗。

**主要人物**：宋徽宗、宋钦宗、蔡京、童贯、金太宗完颜晟

**经过概要**：金军两次围攻开封。蔡京、童贯等"六贼"误国。1127年金军攻破东京汴梁，俘虏徽、钦二帝及宗室后妃三千余人北去，北宋灭亡。

**结果与影响**：北宋灭亡，赵构南渡建立南宋。"靖康之耻"成为此后南宋政治的核心记忆，深刻影响了主战派与主和派的政治斗争。

---

## 十二、南宋

### 秦桧专权与岳飞之死（南宋 · 1138年—1155年）

**背景**：南宋初年主战派与主和派激烈对立，宋高宗倾向议和。

**主要人物**：宋高宗赵构、秦桧、岳飞、韩世忠

**经过概要**：秦桧拜相后力主与金和议。为清除主战派障碍，秦桧以"莫须有"罪名杀害岳飞父子。此后秦桧独揽朝政近20年，排斥异己、打压言论、篡改史书。

**结果与影响**：绍兴和议签订，南宋偏安江南。岳飞之死成为千古冤案，秦桧成为后世奸臣的代名词。

---

### 庆元党禁（南宋 · 1195年—1202年）

**背景**：宋宁宗即位后，外戚韩侂胄与理学派领袖赵汝愚争夺权力。

**主要人物**：韩侂胄、赵汝愚、朱熹

**经过概要**：韩侂胄将赵汝愚贬斥致死，又将朱熹的理学定为"伪学"，列"伪学逆党"名单，禁锢理学派士人。

**结果与影响**：庆元党禁是思想控制与政治斗争结合的典型案例。韩侂胄后因北伐失败被杀，理学此后反而被尊为正统。

---

## 十三、元朝

### 汗位之争与权臣更迭（元 · 1260年—1368年）

**背景**：蒙古帝国分裂后，元朝皇位继承缺乏明确制度。

**主要人物**：忽必烈、阿里不哥、海山、爱育黎拔力八达、燕帖木儿、伯颜

**经过概要**：忽必烈与阿里不哥争位开启了元朝皇位之争的序幕。此后元朝在位时间最短的皇帝仅数十天。权臣燕帖木儿、伯颜等先后把持朝政，废立天子如同儿戏。元顺帝时期朝政更加混乱。

**结果与影响**：政治不稳定加上民族矛盾和自然灾害，激发了红巾军起义等大规模反元斗争，元朝最终被朱元璋推翻。

---

## 十四、明朝

### 靖难之役（明 · 1399年—1402年）

**背景**：明太祖朱元璋死后，建文帝朱允炆削藩，燕王朱棣势力最大。

**主要人物**：建文帝朱允炆、燕王朱棣、齐泰、黄子澄、姚广孝

**经过概要**：朱棣以"清君侧"名义起兵，经四年战争攻入南京。建文帝下落成谜（或自焚，或出逃）。朱棣即位为明成祖，迁都北京。

**结果与影响**：朱棣成为中国历史上唯一一个藩王造反成功的皇帝。他大肆清洗建文旧臣（方孝孺被灭十族），并重修官方历史以美化自身的合法性。

---

### 土木堡之变（明 · 1449年）

**背景**：瓦剌崛起，太监王振怂恿明英宗亲征。

**主要人物**：明英宗朱祁镇、王振、也先、于谦、明代宗朱祁钰

**经过概要**：英宗率50万大军北征，在土木堡被瓦剌也先部包围，明军全军覆没，英宗被俘。于谦拥立郕王朱祁钰为帝（明代宗），组织北京保卫战击退瓦剌。后英宗被释回，被幽禁于南宫。

**结果与影响**：1457年石亨等发动"夺门之变"，英宗复辟，于谦被杀。土木堡之变是明朝由盛转衰的转折点，此后宦官权力不减反增。

---

### 大礼议之争（明 · 1521年—1524年）

**背景**：明武宗无嗣驾崩，兴献王之子朱厚熜以藩王身份入继大统（明世宗嘉靖帝）。

**主要人物**：嘉靖帝、杨廷和、张璁、桂萼

**经过概要**：内阁首辅杨廷和等要求嘉靖帝认孝宗为父，嘉靖帝坚持尊生父兴献王为帝。双方僵持数年，嘉靖帝起用张璁等新进官员对抗旧臣。"左顺门事件"中嘉靖帝廷杖百余名跪谏大臣。

**结果与影响**：嘉靖帝获胜，尊生父为皇帝。通过大礼议，嘉靖帝确立了皇权的绝对权威，打破了内阁大臣制约皇帝的传统。

---

### 东林党争与阉党专权（明末 · 1604年—1644年）

**背景**：万历后期朝政腐败，顾宪成等在无锡东林书院讲学议政，形成东林党。

**主要人物**：顾宪成、高攀龙（东林党）；魏忠贤（阉党）；崇祯帝

**经过概要**：天启年间，太监魏忠贤把持朝政，自称"九千岁"，大肆迫害东林党人。杨涟上疏弹劾魏忠贤二十四大罪，反被下狱折磨至死。左光斗等"六君子"先后遇害。崇祯帝即位后铲除魏忠贤，但东林党与其他派系的争斗继续。

**结果与影响**：朋党与阉党的反复斗争严重内耗了明朝的政治资源。崇祯帝虽诛魏忠贤但无力挽回局面，明朝在内忧外患中灭亡。

---

## 十五、清朝

### 鳌拜专权（清 · 1661年—1669年）

**背景**：顺治帝死后，年幼的康熙帝即位，四位辅政大臣中鳌拜逐渐独揽大权。

**主要人物**：康熙帝、鳌拜、索尼、苏克萨哈、遏必隆

**经过概要**：鳌拜排挤其他辅政大臣，矫旨杀苏克萨哈，专横跋扈。康熙帝亲政后，以少年侍卫为"布库"（摔跤手）陪练，1669年在宫中擒拿鳌拜，将其革职拘禁。

**结果与影响**：少年天子智擒权臣，展示了非凡的政治才能。康熙由此开始亲政，开创康乾盛世。

---

### 九子夺嫡（清 · 1708年—1722年）

**背景**：康熙帝在位61年，皇子众多，太子胤礽两立两废，引发诸皇子激烈争位。

**主要人物**：康熙帝、太子胤礽、大阿哥胤禔、四阿哥胤禛（雍正）、八阿哥胤禩、十四阿哥胤禵

**经过概要**：诸皇子分成多个集团："太子党""大阿哥党""八爷党""四爷党"等。各方拉拢朝臣、互相攻讦。胤礽两次被废，八阿哥一度呼声最高。最终康熙帝遗诏（或秘密立储）传位四阿哥胤禛，即雍正帝。

**结果与影响**：雍正即位后大力打击政敌兄弟，改革秘密建储制度以避免公开争位。九子夺嫡是清代皇位继承最惨烈的事件，历来众说纷纭。

---

### 文字狱（清 · 贯穿清前中期）

**背景**：清朝以少数民族入主中原，对汉族士人的反满思想高度警惕。

**主要人物**：康熙、雍正、乾隆、庄廷鑨、戴名世、吕留良、查嗣庭

**经过概要**：清朝大兴文字狱，从文人著述中搜寻"违碍"字句，株连甚广。主要案件包括：庄廷鑨《明史》案（70余人被杀）、戴名世《南山集》案、吕留良案、乾隆时期的大量诗文案。

**结果与影响**：文字狱严重压制了思想自由和学术发展，知识分子转向考据训诂等"安全"学问。这是中国历史上思想专制的极端表现。

---

### 戊戌变法与戊戌政变（清 · 1898年）

**背景**：甲午战败后民族危机加深，康有为等人上书光绪帝请求变法。

**主要人物**：光绪帝、慈禧太后、康有为、梁启超、谭嗣同、袁世凯、荣禄

**经过概要**：1898年6月至9月，光绪帝颁布一系列维新诏令（"百日维新"），涉及政治、教育、军事改革。保守派以慈禧太后为核心强烈反对。维新派试图争取袁世凯支持"围园杀后"，袁世凯告密。慈禧发动政变，囚禁光绪帝，捕杀"戊戌六君子"（谭嗣同等）。

**结果与影响**：变法失败标志着体制内改良道路受阻。康梁流亡海外，此后革命思潮兴起。"我自横刀向天笑"成为变法志士的悲壮绝唱。
