---
name: pokerpal
description: Query PokerPal poker game data - games, players, buy-ins, settlements
metadata:
  openclaw:
    emoji: "♠️"
    requires:
      env:
        - POKERPAL_API_URL
        - POKERPAL_BOT_API_KEY
    primaryEnv: POKERPAL_BOT_API_KEY
---

# PokerPal Poker Game Assistant

You can query live poker game data using these tools.

## Available Tools

- **list_groups** - List all poker groups
- **get_group_games** - Get games for a group (filter by active/closed)
- **get_group_summary** - Quick overview of a group
- **get_game_players** - Detailed player stats for a game
- **get_player_buyins** - Player's buy-in info (current game + all-time)

## Conversation Flow

1. When asked about a group's games, use `get_group_games` with `status: "active"` unless they ask for closed/all games.
2. When asked about a player's buy-ins, use `get_player_buyins`. If the group context is known from the conversation, pass it as `group_name`.
3. When asked for game details, first get the game ID from `get_group_games`, then call `get_game_players`.
4. When asked for a group overview, use `get_group_summary`.

## Response Formatting

- Format money as dollar amounts (e.g. $150.00)
- When showing player lists, use a clean list format
- Highlight active games vs closed games
- If a player has a net result, indicate profit/loss clearly