# Pod Point Watcher

This skill monitors the live status of a specific Pod Point charging pod using Pod Point's public status endpoint.

It mirrors the behaviour of a native Pod Point watcher:
- Tracks connector **A** and **B**
- Detects when a charger goes from **Charging → Available**
- Detects when **both connectors become available**
- Can either return current status or wait and notify when availability changes

No authentication or API keys are required.

---

## When to use this skill

Use this skill when the user asks things like:

- "Is my Pod Point charger free?"
- "Check pod 10059"
- "Watch my charger and tell me when it's available"
- "Are both connectors free at my Pod Point?"
- "Monitor this Pod Point"

This skill is specifically for **live availability**, not for maps or locations.

---

## Actions

### `podpoint_status`

Returns the current state of connectors A and B.

Example input:

```json
{
  "action": "podpoint_status",
  "podId": "10059"
}
