# Podman Browser Skill

Headless browser automation using Podman + Playwright for scraping JavaScript-rendered pages.

## Requirements

- Podman 5.x+ installed and running
- Node.js 18+ (for running the CLI)
- Internet connection (first run pulls ~1.5GB container image)

## Installation

Create a symlink for easy access:

```bash
chmod +x browse.js
ln -sf "$(pwd)/browse.js" ~/.local/bin/podman-browse
```

First run will pull the Playwright container image (~1.5GB).

## Commands

### `podman-browse` (or `./browse.js`)

Fetch a JavaScript-rendered page and return its text content.

```bash
podman-browse "https://example.com"
```

**Options:**
- `--html` - Return raw HTML instead of text
- `--wait <ms>` - Wait for additional time after load (default: 2000ms)
- `--selector <css>` - Wait for specific element before capturing
- `-h, --help` - Show help

**Examples:**
```bash
# Get rendered text content from Hacker News
podman-browse "https://news.ycombinator.com"

# Get raw HTML
podman-browse --html "https://news.ycombinator.com"

# Wait for specific element
podman-browse --selector ".itemlist" "https://news.ycombinator.com"

# Extra wait time for slow pages
podman-browse --wait 5000 "https://news.ycombinator.com/newest"
```

## How It Works

1. Runs Microsoft's official Playwright container via Podman
2. Uses Chromium in headless mode
3. Waits for JavaScript to render (networkidle + custom wait)
4. Returns text or HTML content

## Container Image

Uses `mcr.microsoft.com/playwright:v1.50.0-noble` with `playwright@1.50.0` npm package (versions must match).

## Files

- `browse.js` - Self-contained Node.js CLI (handles args + spawns podman)
- `SKILL.md` - This documentation

## Notes

- First run will pull the container image (~1.5GB)
- Uses `--ipc=host` for Chromium stability
- Uses `--init` to handle zombie processes
- Sandbox disabled when running as root (fine for trusted sites)
- Each run starts a fresh container (clean but takes ~10-15s)
