# YouTube Video Podcasts

## Key Differences from Audio

- Thumbnails and titles drive discovery (not RSS)
- Clips channels separate from main channel
- Comments have community timestamps
- YouTube algorithm recommends content
- Visual content matters (reactions, demos)

---

## Channel Tracking

For YouTube podcast channels, track:
- Main channel (full episodes)
- Clips channel if exists (short highlights)
- Upload schedule
- Typical episode length
- Guest announcement patterns

---

## Clip Extraction

When user wants highlights:
1. Check if official clips channel has relevant clip
2. Identify "viral moments" from social engagement
3. Use chapter markers if available
4. Generate timestamps for key segments

Clip types to identify:
- Emotional peaks (laughter, tension)
- Quotable moments
- Contrarian takes
- Practical advice
- Meme-worthy exchanges

---

## YouTube-Specific Commands

| User Says | Agent Does |
|-----------|------------|
| "Follow JRE clips" | Track channel, notify on new clips |
| "Find the viral moment" | Identify most-shared segment |
| "What's the timestamp for AI discussion?" | Find topic in chapter markers or transcript |
| "Who was that neuroscientist?" | Identify guest from vague descriptions |

---

## Cross-Platform Guest Tracking

Same guest often appears on multiple YouTube podcasts:
- Lex Fridman
- Joe Rogan (JRE)
- Diary of a CEO
- Huberman Lab
- etc.

When tracking a guest:
1. Find all recent appearances
2. Identify unique content vs repeated talking points
3. Recommend which ONE appearance to watch
4. Note differences in depth/angle

---

## Thumbnail & Title Patterns

YouTube titles often obscure guest identity:
- "This Neuroscientist Reveals..." → identify actual guest
- "Billionaire Explains..." → who is it?
- "The Truth About..." → what's the actual topic?

Parse titles and thumbnails to extract:
- Guest name
- Topic
- Clickbait level
- Actual value signal
