# Growth — Audience, SEO, Monetization

## Discoverability

### Podcast SEO
Optimize for Apple Podcasts, Spotify, and Google:

**Title:** Include main keyword + benefit
- ❌ "The Business Show"
- ✅ "Bootstrapped: Growing a SaaS Without VC"

**Description:** Front-load keywords, clear value prop
```
Learn how to build and scale a profitable SaaS without venture capital.
Weekly interviews with bootstrapped founders sharing real revenue numbers,
growth tactics, and hard-won lessons. For indie hackers and solo founders.
```

**Episode Titles:** Specific > clever
- ❌ "Episode 47: An Interesting Conversation"
- ✅ "How I Grew to $50k MRR with Zero Ads (Sarah Chen, PricingBot)"

### Show Notes SEO
Include:
- Timestamped chapters
- Guest name + company
- Key topics as keywords
- Links mentioned
- Full transcript (for Google indexing)

---

## Social Media Strategy

### Clip-First Approach
Every episode = content factory:
```
1 episode
├── 1 trailer (60s, hooks full episode)
├── 3 insight clips (15-30s each)
├── 1 controversial take clip
├── 1 quote graphic
├── 1 audiogram (waveform + audio)
├── 1 carousel (key takeaways)
└── 1 thread (Twitter/X)
```

### Platform-Specific Tactics

**YouTube**
- Upload full episode + shorts
- Optimize thumbnail (face + 3 words)
- Chapters in description
- End screen linking related episodes

**TikTok/Reels**
- Vertical clips with captions
- Hook in first second
- Trending sounds (when relevant)
- Post 1-3x daily during launch

**LinkedIn**
- Professional insight clips
- Native video (not links)
- Engage in comments
- Tag guests

**Twitter/X**
- Thread breaking down episode
- Quote graphics
- Engage with guest's followers
- Spaces for live discussions

### Posting Cadence
| Platform | Frequency | Best time |
|----------|-----------|-----------|
| YouTube | Episode day + 2-3 shorts/week | 12-3pm |
| TikTok | 1-3x daily clips | 7-9pm |
| LinkedIn | 2-3x/week | Tue-Thu 8-10am |
| Twitter | Daily | 9am, 12pm, 6pm |

---

## Cross-Promotion

### Guest Swaps
Trade appearances with similar-sized shows:
- Same niche, different angle
- Similar audience size (comparable downloads)
- Complementary expertise

### Podcast Networks
Join or create informal networks:
- Shared promotion in episodes
- Newsletter swaps
- Joint social campaigns

### Newsletter Partnerships
- Feature in relevant newsletters
- Sponsor podcast-focused newsletters
- Build own email list from listeners

---

## Analytics & Optimization

### Key Metrics
| Metric | What it tells you |
|--------|-------------------|
| Downloads | Reach |
| Retention curve | Where people drop off |
| Completion rate | Content quality |
| Reviews/ratings | Listener sentiment |
| Social engagement | Clip resonance |
| Subscriber growth | Show momentum |

### Optimization Actions
- High drop-off at intro → Shorten intro, better hook
- Low completion → Episodes too long or pacing issue
- Specific episodes spike → Make more like those
- Reviews mention topic → Double down on that topic

### A/B Testing
Test over 5-10 episodes:
- Episode length variations
- Different intro styles
- Guest vs solo episodes
- Release days/times

---

## Monetization

### Sponsorship
**CPM Model:** $15-50 per 1,000 downloads
- Pre-roll (beginning): Lower CPM, higher skip rate
- Mid-roll (middle): Highest CPM, best engagement
- Post-roll (end): Lowest value

**Outreach:**
1. Build media kit (downloads, demographics, past sponsors)
2. Find brands advertising on similar shows
3. Pitch specific integration ideas, not just "ads"

### Premium/Membership
- **Bonus episodes** — Extended interviews, behind-scenes
- **Early access** — Episodes drop 1 week early
- **Ad-free feed** — Separate RSS for members
- **Community** — Discord, private Q&A

Platforms: Supercast, Patreon, Apple Subscriptions, Spotify

### Other Revenue
- **Courses/products** — Teach what you discuss
- **Consulting** — Use podcast as lead gen
- **Events** — Live podcast recordings, meetups
- **Affiliate** — Products you genuinely recommend

### Revenue Timeline
| Downloads/episode | Realistic revenue |
|-------------------|-------------------|
| <1,000 | Focus on growth, no monetization |
| 1,000-5,000 | Affiliate links, small sponsors |
| 5,000-25,000 | Direct sponsor outreach, mid-roll ads |
| 25,000+ | Premium content, courses, events |

**Key metric:** Downloads in first 7 days is what sponsors care about.
**CPM rates:** $15-25 for host-read, $10-15 for pre-produced.
