# Podcast Formats

## Solo Format

One host sharing expertise, stories, or commentary.

**Strengths:** Full control, no scheduling, consistent brand voice
**Challenge:** Keeping energy without a co-host

### Solo Engagement Techniques
- **Rhetorical questions** — "Have you ever wondered why..."
- **Direct address** — "Here's what I want you to do right now..."
- **Story breaks** — Personal anecdotes every 3-5 minutes
- **Varied pacing** — Speed up for excitement, slow for emphasis
- **Imaginary dialogue** — "You might be thinking..."

### Solo Episode Structure
```
0:00 - Hook (the best insight teased)
0:30 - Intro + episode overview
2:00 - Main content (3-4 segments)
       └── Story → Point → Application pattern
15:00 - Recap + actionable takeaway
16:00 - CTA + outro
```

---

## Interview Format

Host + guest conversation.

**Strengths:** Built-in variety, guest audiences, credibility
**Challenge:** Guest quality, scheduling, making guests shine

### Pre-Interview Research
Before booking, compile:
- Their recent work/projects
- Past interviews (find untold angles)
- Social media hot takes
- Personal stories they've shared
- Potential controversy/sensitive areas

### Question Design
**Layer 1:** Surface questions (what, how)
**Layer 2:** Insight questions (why, what did you learn)
**Layer 3:** Personal questions (how did that feel, what would you tell younger self)

Build an arc: rapport → expertise → vulnerability → inspiration

### Making Guests Shine
- Let them tell stories fully (don't interrupt climaxes)
- Set up their expertise before they speak
- Use their words back to them ("You mentioned...")
- End with a question that lets them be inspiring
- **Silence after answers** — guests fill silence with deeper insights
- **"Tell me more about that"** — better than next question when interesting
- **Record pre-show chat** — often the best material before "we're recording"

### Interview Prep Hack
- Send 5-7 questions in advance, then ask 3 different ones
- Prepared guests give better answers, spontaneous questions reveal more

---

## Panel / Co-Host Format

Multiple hosts discussing topics together.

**Strengths:** Natural conversation, diverse perspectives, banter
**Challenge:** Coordination, everyone talking over each other

### Panel Dynamics
- **Assign roles** — Moderator, devil's advocate, expert, everyman
- **Crosstalk rules** — One person finishes, then respond
- **Balance airtime** — Moderator tracks who's been quiet
- **Planned disagreements** — More engaging than consensus

### Panel Episode Flow
```
0:00 - Cold open (best banter moment)
0:30 - Intros + topic setup
3:00 - Roundtable discussion (each person weighs in)
10:00 - Debate/deep dive on controversial angle
18:00 - Lightning round (quick takes)
20:00 - Final thoughts + close
```

---

## Narrative / Storytelling Format

Produced, scripted, often serial content.

**Strengths:** Highest production value, most addictive format
**Challenge:** Most labor-intensive, needs editing skills

### Narrative Elements
- **Cold open** — Hook with a dramatic moment or question
- **Act structure** — Setup, confrontation, resolution
- **Sound design** — Ambience, music, effects
- **Cliffhangers** — End episodes mid-tension for serial shows
- **Narrator voice** — Consistent tone (intimate, documentary, dramatic)

### Script Format
```
NARRATOR: [tone: contemplative]
On the night of March 15th, everything changed.

[SFX: rain, distant thunder]

SARAH: [archival audio]
I remember exactly where I was standing...

[MUSIC: tension bed fades in]

NARRATOR: [tone: building]
But what Sarah didn't know...
```

---

## Format Selection Guide

| If your goal is... | Choose |
|-------------------|--------|
| Personal brand, thought leadership | Solo |
| Network building, social proof | Interview |
| Entertainment, chemistry showcase | Panel |
| Storytelling, high retention | Narrative |
| Automated content at scale | AI-Generated |
