# Episodes — Planning, Scripting, Show Notes

## Common Mistakes to Avoid

- **Talking about podcasting** on your podcast — listeners don't care about your process
- **Inside jokes without context** — alienates new listeners
- **No episode zero** explaining show premise — people start anywhere
- **Inconsistent episode length** (30 min, then 2 hours) — set expectations
- **No call to action** — "Subscribe and review" at end, every episode
- **Clever over clear titles** — "How to X with Y" beats "Episode 47"

---

## Episode Planning

### Topic Selection
Sources for episode ideas:
- Audience questions (comments, DMs, emails)
- Trending topics in your niche
- Competitor gaps (what they haven't covered)
- Personal experience + lessons learned
- Guest expertise (build episode around their strength)

### Publishing Cadence
- **Consistency beats frequency** — weekly you can sustain beats daily burnout
- **Same day/time builds habit** — "New episode every Tuesday"
- **Buffer of 3-4 episodes** — production problems shouldn't break schedule
- **Seasons allow breaks** — 10-12 episodes, break, return
- **Announce hiatus** — silence without explanation loses subscribers

### Content Calendar
Plan 4-8 weeks ahead:
```
Week 1: Solo - [Topic A] - Evergreen
Week 2: Interview - [Guest B] - Timely
Week 3: Solo - [Topic C] - Audience request
Week 4: Panel - [Roundtable D] - Trending topic
```

Balance:
- Evergreen vs timely content
- Solo vs guest episodes
- Deep dives vs quick hits

### Episode Types
| Type | Length | Frequency |
|------|--------|-----------|
| Standard episode | 30-60 min | Weekly |
| Deep dive | 60-90 min | Monthly |
| Quick hit | 10-20 min | As needed |
| Q&A / mailbag | 20-40 min | Monthly |
| Best-of / compilation | 30-45 min | Quarterly |

---

## Scripting & Outlines

### Solo Episode Outline
```markdown
# Episode: [Title]

## Hook (30s)
- Open with the most interesting insight or question
- Why should they keep listening?

## Intro (60s)
- Welcome + show intro
- What this episode covers
- Why it matters

## Segment 1: [Topic]
- Main point
- Supporting evidence/story
- Practical application

## Segment 2: [Topic]
- Main point
- Story/example
- Actionable takeaway

## Segment 3: [Topic]
- Main point
- Case study
- How to implement

## Recap (2 min)
- Summarize key points
- Single most important takeaway

## CTA + Outro (1 min)
- Subscribe, review, share
- What's next episode
- Sign off
```

### Interview Question Prep
```markdown
# Guest: [Name]

## Research Summary
- Current role/project
- Recent news/work
- Past interview topics (avoid repeating)

## Opening (rapport)
1. How did you get into [field]?
2. What's surprising about your day-to-day?

## Main Questions (expertise)
3. [Topic they're known for] — go deeper
4. Specific project/case study
5. Counterintuitive insight

## Personal/Vulnerable
6. What's a mistake you made early on?
7. What do you wish you knew?

## Forward-looking
8. What's exciting you right now?
9. Advice for someone starting out?

## Rapid Fire (optional)
- Book recommendation
- Underrated tool
- Hot take
```

---

## Show Notes Template

```markdown
# Episode [Number]: [Title]

[2-3 sentence summary]

## Guest
[Name], [Title] at [Company]
- [Website]
- [Twitter/LinkedIn]

## Timestamps
- 00:00 - Introduction
- 02:30 - [Topic 1]
- 12:45 - [Topic 2]
- 25:00 - [Topic 3]
- 35:15 - Rapid fire questions
- 40:00 - Where to find [Guest]

## Key Takeaways
1. [Insight 1]
2. [Insight 2]
3. [Insight 3]

## Resources Mentioned
- [Book/Tool/Link 1]
- [Book/Tool/Link 2]

## Connect
- Subscribe: [Links to platforms]
- Review: [Apple Podcasts link]
- Follow: [Social handles]

## Transcript
[Full transcript for SEO]
```

---

## Title & Description Best Practices

### Titles
**Formula:** [Outcome] + [How/Who] + [Specificity]

Examples:
- "How I Built a $1M Newsletter in 18 Months (Lenny Rachitsky)"
- "The Pricing Strategy That Doubled Our Revenue"
- "Why Most Productivity Advice Is Wrong (And What Works)"

**Avoid:**
- Vague titles ("Great conversation with...")
- Episode numbers only ("Episode 47")
- Inside jokes audience won't get

### Descriptions
Structure:
```
[Hook - why listen?]

[What you'll learn - 3-4 bullet points]

[Guest intro - if applicable]

[CTA - subscribe, review]
```

Example:
```
Most founders get pricing wrong — and leave 30-40% of revenue on the table.

In this episode, you'll learn:
• Why cost-plus pricing destroys margins
• The psychology behind price anchoring
• How to test prices without losing customers
• When to raise prices (and how to communicate it)

Sarah Chen built PricingBot to $50k MRR by mastering these principles.
She shares her exact playbook.

Subscribe for weekly founder insights.
```

---

## Content Repurposing

From one episode, create:
| Asset | Platform | Effort |
|-------|----------|--------|
| Full episode | Apple/Spotify/YouTube | Done |
| Transcript | Blog/SEO | Automated |
| Show notes | Website | 15 min |
| 3 short clips | TikTok/Reels/Shorts | 30 min |
| Quote graphics | Instagram/LinkedIn | 15 min |
| Thread | Twitter/X | 20 min |
| Newsletter | Email | 15 min |
| Blog post | Website | 30 min |

**Rule:** Never publish an episode without at least 3 social clips.
