---
name: Podcast
description: Create and grow podcasts by planning episodes, producing audio or video, generating clips, and building audience across formats.
---

## Core Workflow

Every podcast follows: Concept → Plan → Record/Generate → Edit → Publish → Promote.

Before starting ANY podcast:
1. **Format** — Solo, interview, panel, narrative, or AI-generated
2. **Niche** — Specific topic + audience (not "business" but "bootstrapped SaaS founders")
3. **Cadence** — Weekly, biweekly, or seasonal (consistency > frequency)

## Project Structure

```
~/podcasts/<show>/
├── brand/              # Cover art, intro/outro, music
├── episodes/           # One folder per episode
│   └── 001/
│       ├── outline.md
│       ├── recording.mp3
│       ├── transcript.md
│       ├── show-notes.md
│       └── clips/
├── guests.md           # Guest tracker + relationship notes
└── analytics.md        # Performance patterns
```

## Episode Checklist

Pre-production:
- [ ] Topic researched, angle clear
- [ ] Outline/script with hooks and transitions
- [ ] Guest prep (if interview): questions + research

Post-production:
- [ ] Audio cleaned, levels normalized
- [ ] Show notes with timestamps
- [ ] 3-5 clips extracted for social
- [ ] Thumbnail (if video)

## Quick Reference

| Need | Load |
|------|------|
| Format-specific guidance (solo, interview, panel) | `formats.md` |
| Audio and video production techniques | `production.md` |
| AI-generated podcast creation | `ai-generation.md` |
| Growth, SEO, social, monetization | `growth.md` |
| Episode planning, scripts, show notes | `episodes.md` |
| Tools, platforms, APIs | `tools.md` |

## Critical Rules

1. **Hook in first 30 seconds** — State the value, tease the best moment
2. **Consistency beats perfection** — Ship on schedule, improve incrementally
3. **Clips are growth engine** — Every episode = 3-5 social clips minimum
4. **Engage the niche** — Better to own a small audience than chase a big one
5. **Video is optional but powerful** — YouTube podcast search is growing fast
