---
name: pod-cog
description: "A great podcast needs three things: compelling content, natural-sounding voices, and polished production. CellCog delivers all three — #1 on DeepResearch Bench (Feb 2026) for script depth, frontier multi-voice dialogue, and automatic music + editing. Podcast production, episode scripts, show notes, interview prep, audiograms — single prompt to finished MP3."
metadata:
  openclaw:
    emoji: "🎙️"
author: CellCog
dependencies: [cellcog]
---

# Pod Cog - Complete Podcast Production

**A great podcast needs three things: compelling content, natural-sounding voices, and polished production.** CellCog delivers all three.

- **Content quality:** #1 on DeepResearch Bench (Feb 2026) — scripts built on deep reasoning, not surface-level takes
- **Voice quality:** Frontier multi-voice dialogue with natural delivery, emotion, and pacing across distinct speakers
- **Production quality:** Automatic intro/outro music generation, mixing, and final MP3 delivery — all from a single prompt

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
# Fire-and-forget - returns immediately
result = client.create_chat(
    prompt="[your podcast request]",
    notify_session_key="agent:main:main",
    task_label="podcast-task",
    chat_mode="agent"  # Agent mode for most podcast content
)
# Daemon notifies you when complete - do NOT poll
```

---

## What You Can Create

### Episode Scripts

Full scripts or outlines:

- **Solo Episodes**: "Write a script for a 20-minute solo episode on productivity"
- **Interview Prep**: "Create questions and flow for interviewing a startup founder"
- **Panel Shows**: "Write a structured outline for a 3-person discussion"
- **Narrative Podcasts**: "Script a true-crime style narrative episode"

**Example prompt:**
> "Write a script for a 25-minute solo podcast episode:
> 
> Show: 'The Indie Hacker Pod' - for bootstrapped founders
> Topic: Why I stopped chasing product-market fit
> 
> Structure:
> - Hook (why this matters)
> - Story (my journey with 3 failed products)
> - Framework (what I do instead now)
> - Actionable takeaways
> - CTA (newsletter signup)
> 
> Tone: Conversational, honest, like talking to a friend who's building something
> 
> Include: Suggested timestamps for chapters"

### Show Notes

Professional episode documentation:

- **Standard Show Notes**: "Create show notes with timestamps and links"
- **SEO-Optimized**: "Write show notes optimized for search"
- **Newsletter Format**: "Convert episode into newsletter-style show notes"
- **Chapter Markers**: "Generate chapter markers with timestamps"

**Example prompt:**
> "Create show notes for Episode 47: 'The Art of Cold Email'
> 
> Episode summary: Interview with Sarah, who booked 50 meetings with cold email
> 
> Include:
> - Episode summary (2-3 paragraphs)
> - Key timestamps (I'll add exact times later)
> - Guest bio with links
> - Resources mentioned
> - Key quotes from the episode
> - CTA to subscribe
> 
> Format for both website and podcast app descriptions"

### Intros & Outros

Consistent show branding:

- **Show Intros**: "Write a 30-second podcast intro script"
- **Episode Intros**: "Create a template for episode-specific intros"
- **Outros**: "Write an outro with CTAs"
- **Ad Reads**: "Create a host-read ad script template"

**Example prompt:**
> "Write a podcast intro script (30 seconds when spoken):
> 
> Show: 'Build in Public' - weekly show about transparent entrepreneurship
> Host: Jamie
> 
> Should include:
> - Show name and hook
> - What listeners will learn
> - Quick credibility (without being braggy)
> - Energy: Enthusiastic but not cheesy
> 
> Also create a short outro (15 seconds) with:
> - Thank you
> - Subscribe CTA
> - Social media mention"

### Audiograms & Clips

Social content from episodes:

- **Audiogram Clips**: "Create 3 audiogram-worthy clips from this transcript"
- **Quote Cards**: "Design shareable quote images from episode highlights"
- **Video Clips**: "Generate short video clips for social promotion"
- **Teaser Content**: "Create a 60-second teaser for the episode"

### Interview Preparation

Be the best host:

- **Research Briefs**: "Research this guest and prepare background notes"
- **Question Lists**: "Generate 20 interview questions for this guest"
- **Follow-up Questions**: "Create follow-up questions for these topics"
- **Pre-Interview Guide**: "Create a pre-interview guide to share with guest"

**Example prompt:**
> "Prepare for interviewing Alex Chen, founder of TechStartup (acquired for $50M):
> 
> Research:
> - Their journey
> - Key decisions that led to success
> - Public content they've created
> - Unique angles not often covered
> 
> Generate:
> - 15 main questions (mix of story, tactical, and personal)
> - 5 rapid-fire questions for end of show
> - Topics to avoid (if any obvious ones)
> - Suggested episode structure
> 
> My show focuses on the emotional journey, not just tactics"

### Podcast Planning

Strategic content development:

- **Content Calendars**: "Plan 12 episodes for next quarter"
- **Series Planning**: "Outline a 5-part series on fundraising"
- **Topic Generation**: "Generate 20 episode ideas for a marketing podcast"
- **Season Planning**: "Plan Season 2 themes and episode flow"

---

## Podcast Formats

| Format | Structure | CellCog Helps With |
|--------|-----------|-------------------|
| **Solo** | Just you, sharing expertise | Scripts, outlines, talking points |
| **Interview** | Host + Guest | Questions, research, show notes |
| **Co-Hosted** | Two regular hosts | Discussion outlines, segment ideas |
| **Panel** | Multiple guests | Structure, moderation flow |
| **Narrative** | Produced, story-driven | Scripts, story structure |
| **News/Recap** | Current events | Research, summaries, takes |

---

## Content Types

### Pre-Production
- Research briefs
- Interview questions
- Episode outlines
- Guest prep materials

### Production
- Full scripts
- Talking points
- Ad read scripts
- Intro/outro scripts

### Post-Production
- Show notes
- Transcripts
- Chapter markers
- Summaries

### Promotion
- Audiogram clips
- Social posts
- Newsletter content
- Quote cards

---

## Chat Mode for Podcasts

| Scenario | Recommended Mode |
|----------|------------------|
| Scripts, show notes, interview questions, individual episodes | `"agent"` |
| Season planning, narrative series, comprehensive guest research | `"agent team"` |

**Use `"agent"` for most podcast work.** Episode scripts, show notes, and interview prep execute well in agent mode.

**Use `"agent team"` for deep work** - researching complex guests, planning multi-episode narratives, or developing comprehensive content strategies.

---

## Example Prompts

**Full episode script:**
> "Write a complete script for a 30-minute podcast episode:
> 
> Show: 'Design Matters' - UX/product design podcast
> Episode: 'Why most redesigns fail'
> 
> Format: Solo episode with examples
> 
> Cover:
> 1. The redesign trap (why we love to redesign)
> 2. Case study: 3 famous failed redesigns
> 3. Framework: When to redesign vs iterate
> 4. How to do a redesign right
> 5. Listener action items
> 
> Tone: Authoritative but conversational, include specific examples
> Length: ~4,000 words spoken"

**Interview preparation:**
> "Prepare me for interviewing the CEO of a climate tech startup:
> 
> Guest: Maya Williams, CEO of CarbonCapture.io
> Company: Direct air capture technology, raised $30M Series A
> 
> My podcast: Tech for Good - technology solving real problems
> 
> I want:
> - Background research summary
> - 12 thoughtful questions (avoid generic founder questions)
> - 3 questions about the science (for non-expert audience)
> - 2 questions about the personal journey
> - Suggested follow-ups
> - Episode title options"

**Show notes:**
> "Create comprehensive show notes:
> 
> Episode: Interview with productivity expert about deep work
> Duration: 45 minutes
> 
> Key topics covered:
> - Why multitasking is a myth
> - The 4-hour deep work day
> - Digital minimalism in practice
> - Building a distraction-free environment
> 
> Include:
> - Episode summary (SEO-friendly)
> - Detailed timestamps
> - Key quotes (I'll verify exact wording)
> - All resources mentioned
> - Related episodes to link
> - Subscribe CTAs"

---

## Full Audio Production

When you request a **full podcast episode with audio**, CellCog produces a complete, ready-to-publish file with this default structure:

```
[Intro Music] → [Dialogue/Conversation] → [Outro Music]
```

**CellCog generates all three parts automatically** — the multi-voice dialogue AND short intro/outro music tracks — then stitches them into one final MP3.

### Customizing the Music

You can control the intro and outro music in your prompt:

**Specific direction:**
> "Intro music: 8 seconds of upbeat electronic, think tech podcast energy. Outro music: 6 seconds of the same theme but softer, winding down."

**Genre/mood direction:**
> "Use jazzy lo-fi intro music and a calm acoustic outro."

**Let CellCog decide:**
> "Choose intro and outro music that fits the topic."

If you say nothing about music, CellCog will choose something appropriate for your topic and tone.

### What You Get

| Component | What CellCog Produces |
|-----------|----------------------|
| **Intro music** | ~8 second original track matching your podcast vibe |
| **Dialogue** | Full multi-voice conversation with natural delivery |
| **Outro music** | ~6 second wind-down track |
| **Final file** | Single MP3 with all three concatenated, ready to publish |

### Example with Music Direction

> "Create a 10-minute podcast episode:
> 
> Topic: Why startups should hire generalists first
> Format: Interview between a host and a 3x founder
> Tone: Casual, insightful, with some humor
> 
> Intro music: Upbeat indie rock, 8 seconds, energetic but not overwhelming
> Outro music: Same vibe but mellower, 6 seconds
> 
> Or if you prefer: just say 'Choose music that fits' and CellCog will pick."

---

## Tips for Better Podcast Content

1. **Know your format**: "Conversational interview" vs "structured interview" changes the prep.

2. **Share your voice**: Give examples of your speaking style so scripts sound like you.

3. **Context on guests**: More background = better, more unique questions.

4. **Specify length**: "25 minutes spoken" helps calibrate script length.

5. **Include CTAs**: Tell us what actions you want listeners to take.

6. **Think about chapters**: Modern podcast apps support chapters. Plan for them.
