---
name: pndr
description: Personal productivity app with Ideas/Tasks, Journal, Habits, Package tracking, Lists, and more via MCP
homepage: https://pndr.io
metadata: {"openclaw":{"emoji":"📝","requires":{"bins":["mcporter"]}}}
---

# Pndr

Pndr is your personal productivity command center, now accessible to AI agents via MCP (Model Context Protocol).

## What You Can Do

With Pndr's MCP integration, AI assistants like Claude can:

- **Manage your tasks** - Add, edit, complete, and organize ideas with tags and priorities
- **Track your habits** - Create daily habits and mark them complete automatically
- **Journal** - Record thoughts and retrieve them with fuzzy search
- **Track packages** - Monitor deliveries with tracking numbers and carriers
- **Manage lists** - Create checklists, shopping lists, or any collection of items
- **Get insights** - View today's focus items, kanban boards, accomplishments, and patterns

All of this happens in your own private Pndr account - the AI just provides a natural language interface to your data.

## How It Works

Pndr exposes your personal productivity data through the Model Context Protocol (MCP), allowing AI assistants to interact with your tasks, habits, and journal on your behalf.

**Example conversations:**
- "Add a task to call mom tomorrow with high priority"
- "What's on my plate today?"
- "Mark my exercise habit as complete"
- "Show me my accomplishments this week"
- "Add a journal entry about today's meeting"

The AI uses Pndr's MCP tools behind the scenes to read and write your data securely.

## Who Is This For?

This integration is perfect if you:
- Use an AI assistant (Claude, OpenClaw, etc.) and want it to manage your tasks
- Want natural language access to your productivity data
- Like the idea of saying "add this to my todo list" instead of opening an app
- Already use Pndr and want to access it through AI conversations

## Prerequisites

- A Pndr account (sign up at https://pndr.io)
- An AI assistant that supports MCP (like Claude Desktop or OpenClaw)
- For manual setup: `mcporter` CLI tool

## Setup

### For OpenClaw Users

OpenClaw can set this up automatically! Just ask your assistant:

> "Connect to my Pndr account"

Then provide your Pndr OAuth credentials when prompted.

### Manual Setup

1. **Get Pndr API credentials:**
   - Log in to https://pndr.io
   - Go to Settings → API → Create OAuth Client
   - Give it a name (e.g., "My AI Assistant")
   - Copy your `client_id` and `client_secret`

2. **Get an access token:**
   ```bash
   curl -X POST https://pndr.io/oauth/token \
     -H "Content-Type: application/json" \
     -d '{
       "grant_type": "client_credentials",
       "client_id": "pndr_client_YOUR_CLIENT_ID",
       "client_secret": "YOUR_CLIENT_SECRET"
     }'
   ```

   This returns a JSON response with an `access_token`. Copy it.

3. **Add to your MCP client config:**

   For **mcporter** (`config/mcporter.json`):
   ```json
   {
     "mcpServers": {
       "pndr": {
         "baseUrl": "https://pndr.io/mcp",
         "headers": {
           "Authorization": "Bearer YOUR_ACCESS_TOKEN"
         }
       }
     }
   }
   ```

   For **Claude Desktop** (`claude_desktop_config.json`):
   ```json
   {
     "mcpServers": {
       "pndr": {
         "url": "https://pndr.io/mcp",
         "headers": {
           "Authorization": "Bearer YOUR_ACCESS_TOKEN"
         }
       }
     }
   }
   ```

4. **Test the connection:**
   ```bash
   mcporter list pndr --schema
   ```

   You should see 47 available tools!

## Available Tools

### Ideas & Tasks
- `add_idea` - Create a new idea/task
- `list_ideas` - List and filter ideas
- `edit_idea` - Edit an existing idea
- `complete_idea` - Mark an idea as completed
- `delete_idea` - Delete an idea
- `categorize_idea` - Update tags on an idea
- `set_work_status` - Set work status (not started, in progress, blocked)
- `get_kanban` - Get kanban board view
- `get_today` - Get today's focus items

### Journal & Thoughts
- `add_thought` - Record a journal/diary entry
- `get_thoughts` - Retrieve thoughts with fuzzy search
- `delete_thought` - Delete a thought

### Habits
- `add_habit` - Create a new daily habit
- `list_habits` - List all habits with completion status
- `complete_habit` - Mark a habit as completed for today
- `uncomplete_habit` - Undo a habit completion
- `update_habit` - Update habit text or resources
- `archive_habit` - Archive (delete) a habit

### Checklists
- `add_checklist_item` - Add a checklist item to an idea
- `complete_checklist_item` - Mark checklist item as completed
- `uncomplete_checklist_item` - Mark checklist item as not completed
- `get_checklist` - Get all checklist items for an idea
- `edit_checklist_item` - Edit checklist item text
- `delete_checklist_item` - Delete a checklist item

### Lists
- `add_list` - Create a new list
- `list_lists` - Get all lists with optional filtering
- `get_list` - Get a single list with items
- `update_list` - Update list name, description, or tags
- `delete_list` - Delete a list and all its items
- `add_list_item` - Add an item to a list
- `update_list_item` - Update list item text, notes, or completion
- `toggle_list_item` - Toggle list item completion
- `delete_list_item` - Remove an item from a list
- `reorder_list_items` - Change item order in a list

### Packages
- `add_package` - Track a new package delivery
- `list_packages` - List tracked packages
- `update_package` - Update package information
- `mark_package_delivered` - Mark a package as delivered
- `delete_package` - Delete a package from tracking

### Tags
- `list_tags` - List all available tags
- `create_tag` - Create a new tag
- `delete_tag` - Delete a tag

### Comments
- `add_comment` - Add a comment to an idea
- `list_comments` - List comments on an idea
- `delete_comment` - Delete a comment

### Attachments
- `list_attachments` - List attachments for an idea
- `get_attachment` - Get attachment metadata
- `download_attachment` - Download attachment with base64 data

### Analytics
- `get_accomplishments` - Get summary of completed tasks and habits
- `get_patterns` - Analyze patterns in ideas and thoughts over time

## Usage Examples

Once connected, you can interact with Pndr naturally through your AI assistant:

**Task Management:**
- "Add a high-priority task to finish the presentation by Friday"
- "Show me all my work tasks that are in progress"
- "Mark task [ID] as complete"
- "What should I focus on today?"

**Habits:**
- "Did I complete my exercise habit today?"
- "Mark my reading habit as done"
- "What's my current streak for meditation?"

**Journaling:**
- "Add a journal entry: Had a breakthrough on the project today"
- "What was I thinking about last week around this topic?"
- "Show me my thoughts from January"

**Package Tracking:**
- "Track a package from Amazon, tracking number 1Z999..."
- "What packages am I expecting?"
- "Mark my laptop package as delivered"

**Lists:**
- "Create a grocery list"
- "Add milk and eggs to my shopping list"
- "Show me my reading list"

### Direct CLI Usage (Advanced)

If you're using mcporter directly:

```bash
# Add a task
mcporter call pndr.add_idea text="Build a new feature" tags:work,coding priority:P1

# Check today's focus
mcporter call pndr.get_today

# Complete a habit
mcporter call pndr.complete_habit habit-id:abc123

# Add journal entry
mcporter call pndr.add_thought content="Had a great day working on the project"

# View kanban board
mcporter call pndr.get_kanban tags:work
```

## Authentication

Pndr uses OAuth 2.0 client credentials flow. Access tokens expire after 1 year (365 days).

To refresh your token, repeat the `curl` command from step 2 and update your mcporter config with the new Bearer token.

## Source Code

Open source at https://github.com/Dgershman/pndr

## Pricing

- Free tier: Read-only access
- Pro ($5/mo or $48/year): Full read/write access

## Support

- Documentation: https://pndr.io/docs
- Issues: https://github.com/Dgershman/pndr/issues
