# Career & Leadership

Compressed knowledge module covering the PM-to-Director and Director-to-VP/CPO career transitions, diagnostic coaching logic, executive onboarding methodology, and named failure modes at each level.

## Altitude-Horizon Framework

Two axes define the PM-to-Director shift:

**Altitude (Scope)**
- PM: customer problems, individual features, sprint priorities, specific team dynamics.
- Director: product portfolio, cross-functional systems, organizational dynamics, budget allocation, market positioning.

**Horizon (Time)**
- PM: days, weeks, sprints. A quarter at most.
- Director: quarter as starting point. Annual planning cycles, multi-year strategy.

**Waiter vs. Restaurant Operator** — the core analogy:

| Dimension | PM (Waiter) | Director (Operator) |
|---|---|---|
| Focus | Individual diner experience | Entire system: staffing, margins, menu, suppliers |
| Authority | Influence without control | Portfolio decisions, budget, resource allocation |
| Success metric | Table seven is happy | Restaurant is profitable, consistent, scalable |
| Customer relationship | Direct, daily, intimate | Aggregate patterns, market cohorts |

### Four Transition Zones

1. **Thinking Altitude** — Stop solving individual problems directly. Start designing systems and teams that solve classes of problems.
2. **Persona Shift** — Stop obsessing over individual user personas. Start thinking in buyer personas, market cohorts, organizational stakeholders, executive dynamics.
3. **Hero Syndrome Recovery** — Stop being the person who saves the day. Start getting satisfaction from team success. Your product is your people, not the roadmap.
4. **Direction Creation** — Stop waiting for clear direction from above. Start creating context cascades that translate strategy into team clarity, even when inputs are incomplete.

### Cascading Context Map

When direction is vague, Directors cascade rather than wait:

1. Listen to top-level strategy (QBRs, exec comms)
2. Extract 3-5 key priorities leadership stated
3. Map: "How does our BU accomplish these?"
4. Map: "How does our product portfolio accomplish that?"
5. Map: "What are my team's specific accountabilities?"
6. Communicate the cascade — not just what, but why it connects upward

Template:
```
Company Priority: [leadership's words]
BU Translation: [how your BU contributes]
Portfolio Translation: [how your products contribute]
Team Accountabilities: [what each team owns]
Why This Matters: [what changes, what stays the same]
```

Core principle: even with incomplete direction from above, a Director's job is to fill the gap downward. Creating imperfect-but-useful clarity is a Director skill.

### Named Failure Modes (PM-to-Director)

**Hero Syndrome** — Jumping in to solve problems directly. Regressing to the old reward loop of visible IC wins. Cost: you under-perform as Director while over-functioning as senior IC. Your team doesn't develop.

**Allergic to Process** — Letting high-performing PMs run independent playbooks. Cost: stakeholders across marketing, finance, leadership can't synthesize inconsistent outputs.

**People-Pleaser Leadership** — Wanting the team to like you. Avoiding hard feedback. Saying yes to preserve relationships. Cost: confuse "popular" with "effective."

**Instant Gratification Trap** — Reading leadership books, collecting certifications, asking "what do I need to do to get promoted?" Cost: Director readiness requires war stories and lived humility, not study.

**Black-and-White Thinking** — "This seems obvious." "Why is everything so political?" Cost: fast decisions with low confidence create downstream chaos. Grayscale is the actual terrain.

## PM to Director Transition

### Four Coaching Situations

| Situation | Description | Coaching Priority |
|---|---|---|
| Preparing | Still a PM, building toward Director | Identify weakest transition zone; practice cascade thinking; audit Hero Syndrome habits |
| Interviewing | Active internal or external search | Build one story per transition zone; reframe PM wins in Director language; prepare for the gap question honestly |
| Newly Landed | First 6 months as Director | Run Cascading Context Map immediately; reframe 1-on-1s to strategic altitude; name ambiguity explicitly; resist premature reorgs |
| Recalibrating | Been a Director; something broken | Track IC-vs-coaching time ratio (target: 20% IC); identify what keeps you in Hero Syndrome; create deliberate handoffs |

### Readiness Signals (Preparing)

Assess across four gap areas:
1. **Thinking altitude** — still default to solving customer problems directly?
2. **Stakeholder navigation** — struggle with politics, exec dynamics, cross-functional influence?
3. **Strategic narrative** — can't connect work to company strategy in leadership conversations?
4. **Direction creation** — wait for clarity from above rather than creating it?

Development timeline matters: 6+ months out = build deliberately. 3-6 months = signal readiness, prepare manager conversation. Actively applying = shift to interview prep.

### Interview Preparation

- Work through Altitude-Horizon Framework as a study session: after each section, identify your own story.
- Build one concrete story per transition zone. Use zone names as structure.
- Reframe PM wins: don't open with "I shipped X." Open with "The strategic question my team faced was [X]. Here's how I thought about the portfolio tradeoff."
- For the gap question: "Here's the gap, here's how I've been developing toward it, here's what I'd focus on learning in the first 90 days." Honesty with a plan beats avoidance.

### Newly Landed Coaching

Challenge-specific guidance for inherited teams without clear direction:
1. Run a Cascading Context Map this week. Don't wait for perfect clarity.
2. Redirect 1-on-1s: "Help me see how your product connects to the business goals I'm accountable for."
3. Name ambiguity explicitly: "Here's my best current translation. I'll update it in two weeks."
4. Wait 60-90 days before reorganizing. Understand what's working first.

### Recalibrating Coaching

For Directors still doing IC work after 12+ months:
- Track the ratio: most are at 60-70% IC work. Target is 20%.
- Identify root cause: (a) trust own judgment over team, (b) team undeveloped, (c) getting reward signals from IC behavior.
- Create deliberate handoff for top 3 IC activities with written "done well" criteria.
- Change the reward loop: notice quieter Director wins (PM ships a hard stakeholder conversation alone, team creates its own cascade).
- If entrenched at 1-2 years: consider whether the role fits. Senior IC / Principal PM is a legitimate path.

## Director to VP/CPO Transition

### The Three Ps Framework

VP/CPO accountability spans three dimensions:
- **Product** — Portfolio decisions, roadmap strategy, product family coherence
- **Practice** — How work gets done; process discipline, execution consistency, cross-functional operating rhythms
- **People** — The dominant focus: org structure, talent matching, developing leaders, setting and inspecting expectations

Most Directors are strong in Product, adequate in Practice. People is where the VP/CPO transition most often breaks down.

### The Empowerment Myth

False belief: "Once I get there, I'll finally have authority to do what I always knew was right."
Reality: constraints don't disappear, they change shape. PM = 3x3 Rubik's Cube. Director = 5x5. VP = 7x7. CPO = 9x9. Same principles; exponentially larger blast radius per decision.

### VP to CPO Paradigm Shift

| Dimension | VP Mindset | CPO Mindset |
|---|---|---|
| Core question | "What are we releasing?" | "What business outcomes is the product org accountable for?" |
| Language | Product vocabulary (features, roadmaps, sprints) | Business vocabulary (ROI, revenue, retention, margin, EBITDA) |
| Primary customer | End user | May be investor, buyer, or board — depends on business context |
| Primary team | Product organization | Executive staff (CEO, CFO, CRO, CMO) |

### Time Horizon by Level

| Level | Short-term | Long-term |
|---|---|---|
| IC | Sprint | Quarter |
| Director | Quarter | 1-2 years |
| VP | 1-2 quarters | 3 years |
| CPO | 1-2 quarters | 3-5 years |

Quarterly delivery doesn't stop. Long-term horizon runs in parallel with short-term accountability at every level.

### Alliance Building (Executive Level)

Without executive alliances, you're a "dead man walking." Requirements:
- Weekly engagement with peer executives (CRO, CFO, CMO) — not annual roadmap reviews
- Proactive trade-off communication: "You're not getting X this quarter because of Y, and here's why"
- Bring people along before decisions are announced, not after
- Understand each peer's real priorities, not just stated ones

### CEO Interview Questions (Pre-Acceptance)

Five questions to probe before accepting a VP/CPO role:

1. "What are you expecting from the product org in the first 90 days? The first year?" — Surfaces unrealistic transformation timelines.
2. "Who are the all-stars on your product team, and why?" — Reveals CEO's perceptions and biases.
3. "Who has gaps, and why?" — What does the CEO believe the org weakness is?
4. "What constraints am I working with that I should understand upfront?" — Your actual degrees of freedom.
5. "What does success look like for this role at one year?" — Force specificity. Vague answers are red flags.

**Red flags:** "You can't change the existing roadmap" (loss of basic authority). "Transform the org in six months" (setup for failure). Misalignment between CEO's talent assessment and what you hear elsewhere.

### VP/CPO Readiness Assessment

Four coaching situations mirror the Director advisor:

| Situation | Key Assessment Areas |
|---|---|
| Preparing | Which of the Three Ps is weakest? What's your exposure to executive dynamics? |
| Evaluating/Interviewing | Can you demonstrate executive-level thinking vs. Director-level work? Have you run CEO interview questions? |
| Newly Landed | Getting oriented without acting prematurely? Executive dynamics navigation? People/org assessment? Surfacing unwritten strategy? |
| Recalibrating | Still operating at Director level? Executive relationships broken? Organization underperforming? Unclear success criteria? |

## Executive Onboarding (30-60-90)

### Consultant Mindset

Enter every new VP/CPO role as an external consultant assessing the organization before you're responsible for changing it.
- Observe before diagnosing. Ask questions before declarations.
- Understand how steering connects to rudder — org charts lie; map actual reality.
- Don't throw the big red switch. Understand what inherited structures control first.
- Negotiate upfront: tell your boss Month 1 is explicitly a learning phase.

### Phase 1: Diagnose (Month 1)

**Objective:** Build the body of evidence. Understand reality, not the official version.

1. **Interview everyone** — Direct reports, cross-functional peers (CRO, CFO, CMO, Eng leads), sample of PMs. Questions: "What's working?" / "What's not working?" / "What won't I hear in official briefings?" / "Who should I talk to?"
2. **Let people find you** — Those who proactively schedule time have an agenda. Surface it, evaluate it, note the signal.
3. **Take detailed notes** — Who said it, what their incentive might be, whether multiple independent sources confirm it.
4. **Resist action** — When you see something broken, note it. You don't yet know why it's broken, what it's connected to, or what previous fix attempts failed.

**Deliverable:** Detailed notebook of organizational reality, not yet interpreted.

### Phase 2: Validate (Month 2)

**Objective:** Surface patterns, challenge conclusions, identify people situations.

1. **Reality-check with your boss** — "I'm hearing [X]. This differs from what I understood coming in. Help me understand the history."
2. **Map unwritten strategy** — Ask: "What does the organization actually optimize for when things get hard?" Answer is usually different from mission statement.
3. **Complete people assessment** — Diamonds in the rough (give more scope). Strong but wrong role (have the conversation). Not coachable to needed level (determine timeline).
4. **Identify 3-5 highest-leverage changes** — Not a full transformation plan. These become Month 3 agenda.

**Deliverable:** Interpreted organizational assessment with people map and initial strategic priorities.

### Phase 3: Act with Evidence (Month 3)

**Objective:** Make decisions grounded in collected evidence.

1. **Share organizational assessment** — Bring findings to boss and direct reports. Transparency builds trust and surfaces disagreements before you act.
2. **Run first Cascading Context Map** — Create direction even if strategy above you is still ambiguous. Team has been waiting for context.
3. **Start people conversations** — Diamonds: stretch assignment. Wrong role: honest conversation about mismatch and options. Exits: honesty and care, not avoidance.
4. **Build executive alliance deliberately** — Start weekly alignment practice with CRO, CFO, CMO. Don't wait for them to be surprised.

**Deliverable:** Shared assessment, initial strategic direction, 3-5 active changes underway with clear rationale.

### People Assessment Categories

**Diamonds in the rough:** Capable, undervalued, no champion. Find them by listening for "she's talented but nobody gives her the hard problems" or noticing who provides the most unvarnished information. They become critical early allies.

**Strong people in wrong roles:** Strengths mismatched to scope. Common in fast-growth, post-acquisition, or tenure-based promotion orgs. Coach up if coachable, find another role, or part ways. All three better than leaving mismatch in place.

## Quality Gates

### Anti-Patterns Across All Transitions

**Premature action** — Making structural changes before building the body of evidence. Month 1 changes guarantee expensive reversals.

**Consultant mode too long** — Still gathering information in Month 3. Organizational confidence erodes. Act on best current evidence.

**Title-chasing** — Optimizing for promotion appearance rather than building actual muscles. Interviewers and managers detect the difference.

**Skipping altitude shifts** — Using strategy vocabulary while still making sprint-level decisions (Altitude Theater). If you're in the details, own it. If you're not, delegate fully.

**Empowerment fantasy** — Taking a VP/CPO role expecting constraints to vanish. They scale up, they don't disappear.

**Alliance neglect** — Treating executive peer relationships as secondary to managing direct reports. At VP/CPO, the exec team is your primary operating environment.

**Loudest voice bias** — Forming early opinions from the most vocal person met in Month 1. Only act on themes confirmed by 3+ independent sources.

**Conflating VP and CPO** — Treating Director-to-VP and VP-to-CPO as the same move at different scale. VP-to-CPO is a qualitative change (product-first to business-first), not scope expansion.

**One-and-done cascade** — Running the Context Map once at annual planning, never revisiting. Revisit at major inflection points: quarterly planning, exec changes, pivots, restructuring.

**Kindness confusion** — Shielding teams from hard decisions, softening feedback into meaninglessness. Be transparent about the "why." What you share should be honest and actionable.
