---
name: playwright-browser
description: Set up headless browser automation in Clawdbot using Playwright Chromium. Use when configuring browser tools for WSL/Linux environments, installing browser dependencies, or enabling headless web automation. Handles Chromium installation, system library dependencies, and Clawdbot browser configuration.
---

# Playwright Browser Setup

Configure Clawdbot's browser tool to use Playwright-managed Chromium for headless automation in WSL/Linux environments.

## Quick Setup

Run the setup script to install everything:

```bash
./scripts/setup.sh
```

This will:
1. Install Playwright and Chromium
2. Install required system libraries (requires sudo)
3. Patch Clawdbot config to use the Playwright browser

## Manual Setup

### 1. Install Playwright Chromium

```bash
npx playwright install chromium
```

### 2. Install System Dependencies

Chromium requires NSS and ALSA libraries:

```bash
# Ubuntu/Debian
sudo apt-get install -y libnss3 libasound2t64

# If libasound2t64 doesn't exist (older Ubuntu):
sudo apt-get install -y libnss3 libasound2
```

### 3. Find Chromium Path

```bash
find ~/.cache/ms-playwright -name "chrome" -path "*/chrome-linux64/*" 2>/dev/null | head -1
```

### 4. Configure Clawdbot

Patch the gateway config:

```bash
clawdbot config patch '{"browser": {"executablePath": "<path-from-step-3>", "headless": true, "noSandbox": true}}'
```

Or use the provided script:

```bash
./scripts/configure-clawdbot.sh
```

## Verification

Test the browser works:

```bash
~/.cache/ms-playwright/chromium-*/chrome-linux64/chrome --headless --no-sandbox --disable-gpu --dump-dom https://example.com
```

## Notes

- `noSandbox: true` is required for WSL/container environments
- `headless: true` runs without a visible window (faster, no display needed)
- For visible browser, set `headless: false` and ensure WSLg or X11 is configured
