---
name: plan-i
description: 启动一个新的规划流程，创建新的规划文件。
disable-model-invocation: true
---

启动一个新的规划。

**输入**：用户的请求应当包含变更名称或对想要构建内容的描述。

**步骤**
1. **如果没有提供明确的输入，询问用户想要构建什么**
   使用 **AskUserQuestion Tool**（开放式，无预设选项）询问：
   > "您想要进行什么规划？请描述您想要构建或修复的内容。"

   *逻辑处理*：
   - 根据描述，提炼出简洁的中文规划主题。
   - **命名规则**：主题不允许出现空格，必须使用 "-" 字符连接（例如："检索 列表页" -> "检索-列表页"）。
   - **润色主题**：对主题进行润色，使其更简洁、更具体。

2. **创建新规划**
   - 确认规划名称后，调用 `bash ~/.claude/skills/plan-i/scripts/pl-init.sh` 脚本，传入规划名称以创建新的规划文件。
   - **注意**：严禁检查或读取现有的规划文件，确保是全新创建。

3. **提取想法、生成初步规划并写入文档（关键步骤）**
   - **分析用户原始输入**：提取核心意图、潜在痛点和期望目标。
   - **构思初步规划草案**：基于提取的信息，生成一段结构化的初步规划描述（包含背景、目标、待确认的关键点）。
   - **执行写入操作**：将上述初步规划草案**立即写入**到刚才创建的规划文件中。
      - *注意*：此步骤必须在输出任何提示给用户之前完成，确保文件状态与当前对话同步。

4.  **输出引导并移交控制权**
   - 向用户输出以下固定格式的响应，明确指示下一步操作：

    > "✅ 规划 **[<规划名称>]** 已创建，初步想法已整理写入文档！
    >
    > **📋 初步分析摘要**：
    > [此处简述用户核心意图及已写入的关键点]
    >
    > **🚀 建议深入方向**：
    > 为了细化规划，我们需要结合代码库进行深入探索。建议从以下哪个方向开始？
    > 1. [方向一：例如 - 核心业务流程梳理]
    > 2. [方向二：例如 - 数据模型与存储设计]
    > 3. [方向三：例如 - 现有代码库兼容性分析]
    > 4. [其他自定义方向]
    >
    > 💡 **下一步操作**：
    > 请直接回复您的选择（如“选 1"或“我想先讨论数据模型”）。
    > **收到回复后，请运行 `/plan-c` (或点击 plan-c 技能)**，我将立即读取该文件，针对您的选择深入代码库并完成详细规划迭代。"
## 约束与要求
- **唯一职责**：仅负责初始化和首次写入。**禁止**在此技能中进行深入的代码库扫描或多轮迭代。
- **文件安全**：严禁覆盖已存在的规划文件。若文件名冲突，需提示用户更换名称。
- **顺序严格**：必须先执行 `bash ~/.claude/skills/plan-i/scripts/pl-init.sh` 并写入内容，最后才能输出提示。
- **无代码生成**：除非用户明确指令“开始编码”且规划已完全就绪，否则仅输出规划逻辑和文档更新。
- **交接清晰**：必须明确告知用户下一步需要触发 `plan-c` 技能
- **不允许探讨开发步骤**：不允许探讨开发步骤/实施步骤。
- **不允许列出代码**：不允许列出代码或提供具体实现, 只描述“数据结构是什么”，绝不展示“代码怎么写”。
