---
name: plan-c
description: 于已有规划文件继续对话：智能识别“显式文件加载”意图，优先提供状态总结，支持按需深度迭代。
disable-model-invocation: true
---

继续基于已有规划的深度迭代工作。核心策略是：**若用户显式指定文件路径或仅要求加载，则直接输出总结；若用户提出具体深化需求，则执行代码探索。**

**输入**：
- 典型加载指令：`/plan-c 基于已有规划文件 **plans/xxx/xxx.md** 继续对话`
- 深化指令：`/plan-c 深入分析方向一` 或 `基于规划解决关键点 X`

**执行步骤**
### 第一阶段：上下文感知与模式判定 (关键路由)
1.  **文件定位与加载**
    - **路径提取**：检查用户输入中是否包含明确的文件路径（如 `plans/20260303/...md`）。
        - **若包含路径**：直接读取该指定文件内容。解析当前的 `TODO` 列表、`待确认关键点` 及章节结构。
        - **若无路径但有上下文文件**：读取最近一次引用的规划文件。
        - **若完全无文件**：停止执行并提示："❌ 未找到关联的规划文件。请提供文件路径或使用 `/plan-i` 创建新规划。"
2.  **意图识别与模式路由 (核心逻辑)**
    - 分析用户输入的特征，按以下优先级判定模式：

    - **🔴 高优先级：显式加载/概览模式**
        - **触发条件**：
            1. 用户输入中**包含具体的文件路径**（例如 `plans/.../xxx.md`）。
            2. 或者用户关键词仅为：`加载 `、`查看 `、`总结`、` 状态`、` 概况`、` 继续对话`（且无后续具体分析指令）。
        - **判定逻辑**：视为用户希望“先看看文件里写了什么/现在到哪了”，**不预设**需要立即扫描代码库。
        - 👉 **路由至**：[模式一：快速加载与总结]
    - **🟢 次优先级：深度探索/迭代模式**
        - **触发条件**：
            1. 用户在加载文件后，明确提出了具体分析目标（如：“分析目录结构”、“细化方向二”、“解决待确认点 X"）。
            2. 或者用户指令中包含：`深入 `、` 扫描 `、` 分析 `、` 细化`、` 实现逻辑`。
        - 👉 **路由至**：[模式二：深度探索与迭代]
---
### 模式二：深度探索与迭代 (针对具体分析意图)
*此模式下激活 Plan 模式进行代码库交互。*
1.  **目标锁定**：根据用户选择的方向或提出的具体问题，明确本次迭代的焦点。
2.  **深度探索 (Plan Mode)**
    - 激活 **Plan 模式** 进行代码库探索：
        - 扫描相关目录结构和文件依赖。
        - 分析现有函数签名、数据模型接口。
        - 识别潜在的冲突点或重构需求。
    - *注意*：此阶段只读不写代码，专注于理解逻辑以支撑规划更新。
3.  **规划迭代与文档更新**
    - **转化成果**：将探索到的技术细节转化为具体的规划条目。
    - **增量更新**：
        - 在规划文件中追加新的章节。
        - 更新 `TODO` 列表状态。
        - 移除已解决的 `待确认关键点`。
    - **执行写入**：将更新后的内容保存回原规划文件。
4.  **反馈与循环引导**
    - 输出本次迭代的总结（新增细节、发现的风险）。
    - **引导下一轮**：
    - **引导下一轮**：
      > "📝 规划文档已更新。关于 **[当前方向]** 的分析已完成。
      >
      > 接下来您希望：
      > 1. 继续深入当前方向的细节？
      > 2. 切换到下一个规划方向（推荐：[推荐方向]）？
      >
      > 请直接告诉我您的决定，我将继续为您迭代规划。"
---
## 约束与要求
- **路径优先原则**：一旦检测到用户输入中包含 `plans/.../*.md` 格式的路径，**默认强制进入【模式一】**，除非用户在同一句话中明确包含了“分析”、“扫描”等深度操作指令。
- **前置依赖**：必须依赖已存在的规划文件运行。若无文件，强制引导用户使用 `plan-i`。
- **禁止初始化**：**严禁**调用 `pl-init.sh` 脚本。
- **核心职责**：深度代码探索、逻辑细化、文档持续更新。
- **不允许探讨实施步骤**：不允许探讨开发步骤/实施步骤。
- **不允许列出代码**：不允许列出代码或提供具体实现, 只描述“数据结构是什么”，绝不展示“代码怎么写”。
- **无代码生成**：除非用户明确指令“开始编码”且规划已完全就绪，否则仅输出规划逻辑和文档更新。
- **状态保持**：每次输出都必须基于最新的文件状态，确保规划的一致性。
